/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication.protocol;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;

public class HttpsClient {
    private EBGLogger log = EBGLogger.getInstance().getLogger(HttpsClient.class);
    private HttpsURLConnection connection;
    private URL url;

    public HttpsClient(String host, int port, String uri, Map<String, String> header, int timeout, String method) throws IOException {
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "";
        }
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.url = new URL("https", host, port, uri);
        this.connection = (HttpsURLConnection)this.url.openConnection();
        this.connection.setDoInput(true);
        if ("POST".equalsIgnoreCase(method)) {
            this.connection.setDoOutput(true);
        }
        this.connection.setSSLSocketFactory(sc.getSocketFactory());
        this.connection.setConnectTimeout(2000);
        this.connection.setHostnameVerifier(new TrustAnyHostnameVerifier());
        this.connection.setReadTimeout(timeout * 60 * 1000);
        if (Objects.nonNull(header)) {
            header.forEach((key, value) -> {
                this.connection.setRequestProperty((String)key, (String)value);
                this.log.info("http header: " + key + "=" + value);
            });
        }
        this.connection.setRequestMethod(method);
        try {
            this.connection.connect();
        }
        catch (IOException e) {
            throw new ConnectException(String.format(ResManager.loadKDString((String)"\u5efa\u7acbhttps\u8fde\u63a5\u5f02\u5e38\uff0c%s\u3002", (String)"HttpsClient_0", (String)"ebg-egf-common", (Object[])new Object[0]), host + ":" + port));
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public void closeConnection() {
        this.connection.disconnect();
    }

    public HttpsURLConnection getConnection() {
        return this.connection;
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return s.equalsIgnoreCase(sslSession.getPeerHost());
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

