/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.exception.EBErrorPriKeyCipherException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPriKeyAbsentAliasException;
import kd.ebg.egf.common.exception.EBPubKeyAbsentAliasException;
import kd.ebg.egf.common.framework.communication.util.CertChain;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertReader {
    private static final Logger logger = LoggerFactory.getLogger(CertReader.class);
    private KeyStore keyStore;
    private String certPath;
    private String certPwd;
    private String alias;
    private InputStream stream;
    public static final String PKCS12 = "PKCS12";
    public static final String JKS = "JKS";
    private static String KEY_STORE_TYPE = "PKCS12";
    public static final String PUBLICKEY = "PUBLICKEY";
    public static final String PRIVATEKEY = "PRIVATEKEY";
    private String name;

    public CertReader(String certPath, String certPwd, String alias) {
        this.certPath = certPath;
        this.certPwd = certPwd;
        this.alias = alias;
    }

    public CertReader(InputStream stream, String certPwd, String alias) {
        this.stream = stream;
        this.certPwd = certPwd;
        this.alias = alias;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static void setKeyStoreTypr(String type) {
        KEY_STORE_TYPE = type;
    }

    public PrivateKey getPrivateKey() throws Exception {
        String alias = this.getAlias();
        if (StringUtils.isEmpty((String)alias)) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u89e3\u6790\u8bc1\u4e66\u79c1\u94a5\u9519\u8bef\uff0c\u8bc1\u4e66\u522b\u540d\u4e3a\u7a7a\u3002", (String)"CertReader_3", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        Key key = null;
        try {
            key = this.keyStore.getKey(alias, this.certPwd.toCharArray());
        }
        catch (UnrecoverableKeyException e) {
            throw new EBErrorPriKeyCipherException(ResManager.loadKDString((String)"\u89e3\u6790\u8bc1\u4e66\u79c1\u94a5\u9519\u8bef\uff0c\u79c1\u94a5\u5bc6\u7801\u9519\u8bef\u3002", (String)"CertReader_4", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
        if (key != null) {
            return (PrivateKey)key;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8bc1\u4e66\u79c1\u94a5\u9519\u8bef\uff0c\u8bc1\u4e66\u4e0d\u5b58\u5728\u7684\u522b\u540d%s\u3002", (String)"CertReader_5", (String)"ebg-egf-common", (Object[])new Object[0]), alias);
        throw new EBPriKeyAbsentAliasException(errorMsg);
    }

    public PublicKey getPublicKey() throws Exception {
        return this.getPublicKey("");
    }

    public PublicKey getPublicKey(String alias) throws Exception {
        if (StringUtils.isEmpty((String)alias) && StringUtils.isEmpty((String)(alias = this.getAlias()))) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u89e3\u6790\u8bc1\u4e66\u516c\u94a5\u9519\u8bef\uff0c\u8bc1\u4e66\u94fe\u4e3a\u7a7a\u3002", (String)"CertReader_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        Certificate certificate = this.getCertificate(alias);
        if (certificate == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8bc1\u4e66\u516c\u94a5\u9519\u8bef\uff0c\u8bc1\u4e66\u94fe\u4e0d\u5b58\u5728\u7684\u522b\u540d%s\u3002", (String)"CertReader_2", (String)"ebg-egf-common", (Object[])new Object[0]), alias);
            throw new EBPubKeyAbsentAliasException(errorMsg);
        }
        return certificate.getPublicKey();
    }

    public String getAlias() throws Exception {
        if (null != this.alias && !"".equalsIgnoreCase(this.alias)) {
            return this.alias;
        }
        Enumeration<String> aliases = this.keyStore.aliases();
        String temp = "";
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append(ResManager.loadKDString((String)"----------------- \u8bc1\u4e66\u94fe ----------------------", (String)"CertReader_0", (String)"ebg-egf-common", (Object[])new Object[0])).append("\r\n");
        while (aliases.hasMoreElements()) {
            if (StringUtils.isEmpty((String)temp)) {
                temp = aliases.nextElement();
                sb.append(temp).append("\r\n");
                continue;
            }
            sb.append(aliases.nextElement()).append("\r\n");
        }
        sb.append("-----------------------------------------------");
        logger.info(sb.toString());
        if (!StringUtils.isEmpty((String)temp)) {
            return temp;
        }
        return null;
    }

    private String certChain() throws Exception {
        if (this.name == null) {
            return null;
        }
        logger.info("----------------- \u8bc1\u4e66\u94fe ----------------------");
        Enumeration<String> aliases = this.keyStore.aliases();
        ArrayList<String> chain = new ArrayList<String>(1);
        while (aliases.hasMoreElements()) {
            String temp = aliases.nextElement();
            logger.info(temp);
            chain.add(temp);
        }
        logger.info("-----------------------------------------------");
        if (this.name.equalsIgnoreCase(PRIVATEKEY) && CertChain.root.getName().equalsIgnoreCase("")) {
            for (String certName : chain) {
                int index = certName.indexOf("(");
                if (index != -1 || this.alias.equalsIgnoreCase(certName)) continue;
                CertChain.setRoot(certName);
                break;
            }
        } else if (this.name.equalsIgnoreCase(PUBLICKEY)) {
            CertChain instance = null;
            boolean flag = true;
            while (flag) {
                flag = false;
                for (String certName : chain) {
                    int start = certName.indexOf("(");
                    if (start <= 0) continue;
                    int end = certName.indexOf(")");
                    String depAlias = certName.substring(start + 1, end);
                    CertChain last = CertChain.root.getLast();
                    int index = last.getName().indexOf("(");
                    String prefix = last.getName();
                    if (index > 0) {
                        prefix = last.getName().substring(0, index);
                    }
                    if (!prefix.trim().equalsIgnoreCase(depAlias.trim())) continue;
                    instance = new CertChain(certName);
                    last.setNext(instance);
                    flag = true;
                }
            }
            return CertChain.root.getLast().getName();
        }
        return "";
    }

    public void initKeyStore() throws Exception {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        if (null == this.stream) {
            this.stream = new FileInputStream(new File(this.certPath));
        }
        try {
            this.keyStore.load(this.stream, this.certPwd.toCharArray());
        }
        catch (Throwable e) {
            throw new EBErrorPriKeyCipherException(ResManager.loadKDString((String)"\u89e3\u6790\u8bc1\u4e66\u79c1\u94a5\u9519\u8bef\uff0c\u79c1\u94a5\u5bc6\u7801\u9519\u8bef\u3002", (String)"CertReader_4", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
        finally {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    public Certificate getCertificate() throws Exception {
        return this.keyStore.getCertificate(this.getAlias());
    }

    public Certificate getCertificate(String alias) throws Exception {
        return this.keyStore.getCertificate(alias);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCertPwd() {
        return this.certPwd;
    }

    public void setCertPwd(String certPwd) {
        this.certPwd = certPwd;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public static String getPKCS12() {
        return PKCS12;
    }

    public static String getJKS() {
        return JKS;
    }

    public static String getKeyStoreType() {
        return KEY_STORE_TYPE;
    }

    public static void setKeyStoreType(String keyStoreType) {
        KEY_STORE_TYPE = keyStoreType;
    }

    public static String getPUBLICKEY() {
        return PUBLICKEY;
    }

    public static String getPRIVATEKEY() {
        return PRIVATEKEY;
    }

    public String getName() {
        return this.name;
    }
}

