/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.lock;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.exception.EBConnection;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBExceptionEnum;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.model.monitor.MonitorRequestInfo;
import kd.ebg.egf.common.repository.monitor.BankReqRecordRepository;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.cluster.ClusterManager;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import org.apache.curator.CuratorConnectionLossException;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.zookeeper.KeeperException;

public class DistributedFepAccess
implements FEPAccess {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DistributedFepAccess.class);
    public static final String entityName = "aqap_login_lock_monitor";
    public static final String properties = "time_stamp,thread_name,biz_type,date_time,node,log_no,trace_no,bank_version,bank_login,lock_path";
    private static final Integer TYPE_START = 0;
    private static final Integer TYPE_END = 1;
    private List<String> toType = Arrays.asList("balance", "batchBalance", "detail", "queryPay", "queryOverseaPay", "queryLinkpay");
    private String key;
    private int timeout = 60000;
    private int concurrencyCount;
    private InterProcessSemaphoreV2 semaphore;
    private ConcurrentMap<String, Lease> leaseConcurrentMap;
    static ThreadLocal<Lease> leaseThreadLocal = new ThreadLocal();

    public DistributedFepAccess(String key, int concurrencyCount) {
        String dubboTimeOut = System.getProperty("dubbo.consumer.timeout");
        if (StringUtils.isNotEmpty(dubboTimeOut)) {
            try {
                this.timeout = Integer.parseInt(dubboTimeOut);
            }
            catch (NumberFormatException e) {
                logger.error("\u8d85\u65f6\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", e);
            }
        }
        this.key = key;
        this.concurrencyCount = concurrencyCount > 0 ? concurrencyCount : 1;
        ClusterManager clusterManager = ClusterManager.getInstance();
        if (clusterManager == null) {
            logger.error("clusterManager\u4e3a\u7a7a");
        } else {
            this.semaphore = clusterManager.getSemaphore(key, this.concurrencyCount);
        }
        this.leaseConcurrentMap = new ConcurrentHashMap<String, Lease>(32);
    }

    private String getValue(String nodePath) {
        ClusterManager clusterManager = ClusterManager.getInstance();
        return clusterManager.getNodeValue(nodePath);
    }

    private void setNodeTime(String nodePath) {
        ClusterManager clusterManager = ClusterManager.getInstance();
        clusterManager.setNodeValue(nodePath);
    }

    private void setNodeInfo(String nodePath) {
        ClusterManager clusterManager = ClusterManager.getInstance();
        EBContext context = EBContext.getContext();
        String bizName = context.getBizName();
        String logNo = context.getLogger_batch_no();
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("timeStamp", String.valueOf(System.currentTimeMillis()));
        map.put("threadName", Thread.currentThread().getName());
        map.put("bizType", bizName);
        map.put("dateTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        map.put("node", SingleNodeIDGetter.getInstance().nodeID());
        map.put("logNo", logNo);
        map.put("traceNo", RequestContext.get().getTraceId());
        map.put("bankVersion", context.getBankVersionID());
        map.put("bankLogin", context.getBankLoginID());
        map.put("lockPath", nodePath);
        String jsonStr = JsonUtil.toJson(map);
        clusterManager.setNodeValue(nodePath, jsonStr);
        this.saveLockInfo(map);
    }

    private boolean deleteNode(String nodePath) {
        ClusterManager clusterManager = ClusterManager.getInstance();
        return clusterManager.deleteNode(nodePath);
    }

    private boolean isExisted(String nodePath) {
        ClusterManager clusterManager = ClusterManager.getInstance();
        return clusterManager.isExistedNode(nodePath);
    }

    private void checkParticipantNodes() {
        try {
            Collection collection = this.semaphore.getParticipantNodes();
            StringBuilder sb = new StringBuilder();
            if (collection.size() > 0) {
                sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u524d\u7f6e\u673a\u9501ZK\u8282\u70b9:", (String)"DistributedFepAccess_0", (String)"ebg-egf-common", (Object[])new Object[0])).append("\r\n");
                for (String nodeName : collection) {
                    sb.append("/semaphore/").append(this.key).append("/leases/").append(nodeName).append("\r\n");
                    String nodePath = "/semaphore/" + this.key + "/leases/" + nodeName;
                    String value = this.getValue(nodePath);
                    logger.info("\u524d\u7f6e\u673a\u9501[ " + nodeName + " ]\u8282\u70b9\u503c\u4e3a\uff1a" + value);
                    if (!StringUtils.isNotEmpty(value)) continue;
                    try {
                        Long ll = Long.valueOf(value);
                        if (System.currentTimeMillis() - ll <= 3600000L) continue;
                        this.deleteNode(nodePath);
                        logger.info("\u524d\u7f6e\u673a\u9501[ " + nodeName + " ]\u8282\u70b9\u8fc7\u671f\uff0c\u6709\u6548\u65f6\u95f4\uff1a3600s");
                    }
                    catch (NumberFormatException e) {
                        logger.info("\u4e34\u65f6\u9501\u8282\u70b9\u5b58\u50a8\u7684\u503c\u4e0d\u4e3a\u6570\u5b57\u7c7b\u578b\uff0c\u91cd\u65b0\u8bbe\u7f6e\u4e3a\u65f6\u95f4\u6233");
                        this.setNodeTime(nodePath);
                    }
                }
                logger.info(sb.toString());
            }
        }
        catch (Throwable e) {
            if (e instanceof KeeperException.NoNodeException) {
                logger.info("\u5f53\u524d\u524d\u7f6e\u673a\u9501\u672a\u5360\u7528");
            }
            logger.error(e.getMessage());
        }
    }

    private boolean isEBG_SIM() {
        return "EBG_SIM".equals(EBContext.getContext().getBankVersionID());
    }

    @Override
    public void lock() {
        if (this.isEBG_SIM()) {
            this.record("processTime", TYPE_START);
            return;
        }
        boolean isConnected = ClusterManager.getInstance().isConnection();
        try {
            Lease acquire;
            if (isConnected) {
                logger.info("\u51c6\u5907\u83b7\u53d6\u5206\u5e03\u5f0f\u6388\u6743\uff0c\u7ebf\u7a0b\uff1a{};\r\n\u5f53\u524d\u4e1a\u52a1\u7684\u524d\u7f6e\u673a\u5e76\u53d1\u9501\u6570\u91cf\u4e3a{}", Thread.currentThread().getName(), this.concurrencyCount);
                this.freeExpiredLock();
                EBContext context = EBContext.getContext();
                String bizName = context.getBizName();
                this.record("waitTime", TYPE_START);
                if (StringUtils.isNotEmpty(bizName) && this.toType.contains(bizName)) {
                    acquire = this.semaphore.acquire((long)this.timeout, TimeUnit.MILLISECONDS);
                    if (acquire == null) {
                        throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u524d\u7f6e\u673a\u9501\u8d85\u65f6\uff0c\u8d85\u65f6\u65f6\u95f4\uff1a%s\u3002", (String)"DistributedFepAccess_1", (String)"ebg-egf-common", (Object[])new Object[0]), this.timeout));
                    }
                } else {
                    acquire = this.semaphore.acquire();
                }
                if (acquire == null) {
                    throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"Lease\u4e3a\u7a7a\u503c\u3002", (String)"DistributedFepAccess_2", (String)"ebg-egf-common", (Object[])new Object[0]));
                }
                this.leaseConcurrentMap.put(Thread.currentThread().getName(), acquire);
                leaseThreadLocal.set(acquire);
            } else {
                throw new EBConnection(ResManager.loadKDString((String)"\u4e0ezookeeper\u8fde\u63a5\u5df2\u65ad\u5f00\u3002", (String)"DistributedFepAccess_4", (String)"ebg-egf-common", (Object[])new Object[0]));
            }
            this.record("waitTime", TYPE_END);
            String nodePath = "/semaphore/" + this.key + "/leases/" + acquire.getNodeName();
            this.setNodeInfo(nodePath);
            String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6388\u6743\u6210\u529f\uff0c%s", (String)"DistributedFepAccess_3", (String)"ebg-egf-common", (Object[])new Object[0]), nodePath);
            logger.info(msg);
            this.record("processTime", TYPE_START);
        }
        catch (Throwable e) {
            if (e instanceof EBConnection) {
                throw EBExceiptionUtil.loginAccessException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8fde\u63a5\u5f02\u5e38\uff1a%s", (String)"DistributedFepAccess_5", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage()), e);
            }
            if (e instanceof CuratorConnectionLossException || e instanceof KeeperException.ConnectionLossException) {
                throw EBExceiptionUtil.loginAccessException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u5931\u53bb\u4e0ezookeeper\u8fde\u63a5\u3002", (String)"DistributedFepAccess_6", (String)"ebg-egf-common", (Object[])new Object[0]), e);
            }
            throw EBExceiptionUtil.loginAccessException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u3002", (String)"DistributedFepAccess_7", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    @Override
    public void lock(int time) {
        boolean isConnected = ClusterManager.getInstance().isConnection();
        try {
            Lease acquire;
            if (isConnected) {
                logger.info("\u51c6\u5907\u83b7\u53d6\u5206\u5e03\u5f0f\u6388\u6743\uff0c\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName());
                acquire = this.semaphore.acquire((long)time, TimeUnit.SECONDS);
                if (acquire == null) {
                    throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u524d\u7f6e\u673a\u9501\u8d85\u65f6\uff0c\u8d85\u65f6\u65f6\u95f4\uff1a%s\u3002", (String)"DistributedFepAccess_1", (String)"ebg-egf-common", (Object[])new Object[0]), this.timeout));
                }
                if (acquire == null) {
                    throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"Lease\u4e3a\u7a7a\u503c\u3002", (String)"DistributedFepAccess_2", (String)"ebg-egf-common", (Object[])new Object[0]));
                }
            } else {
                throw new EBConnection(ResManager.loadKDString((String)"\u4e0ezookeeper\u8fde\u63a5\u5df2\u65ad\u5f00\u3002", (String)"DistributedFepAccess_4", (String)"ebg-egf-common", (Object[])new Object[0]));
            }
            this.leaseConcurrentMap.put(Thread.currentThread().getName(), acquire);
            leaseThreadLocal.set(acquire);
        }
        catch (Throwable e) {
            if (e instanceof EBConnection) {
                throw EBExceiptionUtil.loginAccessException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8fde\u63a5\u5f02\u5e38\uff1a%s", (String)"DistributedFepAccess_5", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage()), e);
            }
            if (e instanceof CuratorConnectionLossException || e instanceof KeeperException.ConnectionLossException) {
                throw EBExceiptionUtil.loginAccessException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u5931\u53bb\u4e0ezookeeper\u8fde\u63a5\u3002", (String)"DistributedFepAccess_6", (String)"ebg-egf-common", (Object[])new Object[0]), e);
            }
            throw EBExceiptionUtil.loginAccessException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u3002", (String)"DistributedFepAccess_7", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    @Override
    public boolean isFree() {
        try {
            Collection tempNodes = this.semaphore.getParticipantNodes();
            logger.info("ZK\u5206\u5e03\u5f0f\u9501\u5f53\u524d\u4e34\u65f6\u8282\u70b9\u7684\u4e2a\u6570\uff1a" + tempNodes.size());
            logger.info("\u5f53\u524d\u5206\u5e03\u5f0f\u9501\u4e2a\u6570\u4e3a\uff1a" + this.concurrencyCount);
            return tempNodes.size() < this.concurrencyCount;
        }
        catch (Throwable e) {
            return true;
        }
    }

    @Override
    public void release() {
        if (this.isEBG_SIM()) {
            this.record("processTime", TYPE_END);
            return;
        }
        Lease lease = (Lease)this.leaseConcurrentMap.get(Thread.currentThread().getName());
        if (Objects.nonNull(lease)) {
            boolean isConnected = ClusterManager.getInstance().isConnection();
            if (isConnected) {
                this.semaphore.returnLease(lease);
                this.leaseConcurrentMap.remove(Thread.currentThread().getName(), lease);
                leaseThreadLocal.remove();
                String nodePath = "/semaphore/" + this.key + "/leases/" + lease.getNodeName();
                this.deleteLockInfo(nodePath);
                String msg = String.format(ResManager.loadKDString((String)"\u91ca\u653e\u5206\u5e03\u5f0f\u6388\u6743\u6210\u529f\uff0c%s", (String)"DistributedFepAccess_8", (String)"ebg-egf-common", (Object[])new Object[0]), nodePath);
                logger.info(msg);
            } else {
                logger.error("zookeeper\u8fde\u63a5\u5f02\u5e38\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u6388\u6743\u5931\u8d25\uff0c" + lease.getNodeName());
            }
        } else {
            lease = leaseThreadLocal.get();
            if (Objects.nonNull(lease)) {
                this.semaphore.returnLease(lease);
                leaseThreadLocal.remove();
                StringBuilder sb = new StringBuilder();
                sb.append("/semaphore/").append(this.key).append("/leases/").append(lease.getNodeName());
                String nodePath = sb.toString();
                this.deleteLockInfo(nodePath);
                logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u6388\u6743\u5b8c\u6210");
            } else {
                logger.info("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u83b7\u53d6\u6388\u6743");
            }
        }
        this.record("processTime", TYPE_END);
    }

    private void record(String key, int type) {
        LocalDateTime now = LocalDateTime.now();
        Long currentTimeMillis = now.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        if (type == TYPE_START) {
            RequestContextUtils.setRunningParam(key, String.valueOf(currentTimeMillis));
            if ("waitTime".equalsIgnoreCase(key)) {
                RequestContextUtils.setRunningParam("waitLockTime", JsonUtil.toJson(now));
            }
        } else if (type == TYPE_END) {
            String lastTime = RequestContextUtils.getRunningParam(key);
            if (lastTime != null) {
                long time = currentTimeMillis - Long.parseLong(lastTime);
                RequestContextUtils.setRunningParam(key, String.valueOf(time));
                if ("waitTime".equalsIgnoreCase(key)) {
                    logger.info("\u7b49\u5f85\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u8017\u65f6\uff1a{} ms", (Object)time);
                } else {
                    logger.info("\u94f6\u884c\u8bf7\u6c42\u5904\u7406\u8017\u65f6\uff1a{} ms", (Object)time);
                }
            }
            if ("waitTime".equalsIgnoreCase(key)) {
                RequestContextUtils.setRunningParam("getLockTime", JsonUtil.toJson(now));
            } else if ("processTime".equalsIgnoreCase(key)) {
                try {
                    this.store();
                }
                catch (Throwable e) {
                    logger.error("\u8bb0\u5f55\u8bf7\u6c42\u7edf\u8ba1\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff1a{}", e.getMessage());
                }
            }
        }
    }

    private void store() {
        int state;
        LocalDateTime dateTime;
        EBContext context = EBContext.getContext();
        String requestID = context.getRequestSeqID();
        MonitorRequestInfo monitorRequestInfo = this.getMonitorRequestInfo(requestID);
        Map<String, String> map = context.getRunningParams();
        long processTime = 0L;
        long waitTime = 0L;
        if (map.containsKey("processTime")) {
            processTime = Long.parseLong(map.get("processTime"));
        }
        if (map.containsKey("waitTime")) {
            waitTime = Long.parseLong(map.get("waitTime"));
        }
        if (map.containsKey("waitLockTime")) {
            dateTime = JsonUtil.fromJson(map.get("waitLockTime"), LocalDateTime.class);
            monitorRequestInfo.setWaitLockTime(dateTime);
        }
        if (map.containsKey("getLockTime")) {
            dateTime = JsonUtil.fromJson(map.get("getLockTime"), LocalDateTime.class);
            monitorRequestInfo.setGetLockTime(dateTime);
        }
        if (EBExceptionEnum.isConnectionException(state = context.getProcessFlag()) && map.containsKey("Exception")) {
            monitorRequestInfo.setExtData(map.get("Exception"));
            monitorRequestInfo.setStatus(EBException.CONNECTION_EXCEPTION);
        }
        String bankVersion = context.getBankVersionID();
        BankLoginConfigKey key = new BankLoginConfigKey();
        key.setBankLoginId(context.getBankLoginID());
        key.setBankVersionId(bankVersion);
        key.setCustomID(context.getCustomID());
        key.setBankConfigId("leaseNum");
        int loginLockNum = this.getBankLoginLeaseNum(key);
        boolean isBlock = waitTime > 3000L;
        monitorRequestInfo.setRequestID(requestID);
        monitorRequestInfo.setBlockFlag(isBlock);
        monitorRequestInfo.setBlockMillis(waitTime);
        monitorRequestInfo.setProcessMillis(processTime);
        monitorRequestInfo.setCustomID(context.getCustomID());
        monitorRequestInfo.setBankVersionID(context.getBankVersionID());
        monitorRequestInfo.setBankLoginID(context.getBankLoginID());
        monitorRequestInfo.setType(context.getBizName());
        monitorRequestInfo.setLoginLockNum(loginLockNum);
        BankReqRecordRepository bankReqRecordRepository = BankReqRecordRepository.getInstance();
        bankReqRecordRepository.save(monitorRequestInfo);
    }

    private MonitorRequestInfo getMonitorRequestInfo(String id) {
        EBContext context = EBContext.getContext();
        Map<String, String> requestMap = CosmicCache.getAll(context.getCustomID());
        MonitorRequestInfo monitorRequestInfo = requestMap != null && requestMap.containsKey(id) ? JsonUtil.fromJson(requestMap.get(id), MonitorRequestInfo.class) : new MonitorRequestInfo();
        return monitorRequestInfo;
    }

    private int getBankLoginLeaseNum(BankLoginConfigKey key) {
        try {
            String leaseNumStr = BankLoginConfigService.getInstance().getBankLoginConfigValue(key);
            if (StringUtils.isNotEmpty(leaseNumStr) && StringUtils.isNumeric(leaseNumStr)) {
                return Integer.parseInt(leaseNumStr);
            }
            return 1;
        }
        catch (Throwable e) {
            logger.error("\u67e5\u8be2\u524d\u7f6e\u673a\u5e76\u53d1\u9501\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), e);
            return 1;
        }
    }

    private void saveLockInfo(Map<String, String> map) {
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            dynamicObject.set("time_stamp", (Object)map.get("timeStamp"));
            dynamicObject.set("thread_name", (Object)map.get("threadName"));
            dynamicObject.set("biz_type", (Object)map.get("bizType"));
            dynamicObject.set("date_time", (Object)map.get("dateTime"));
            dynamicObject.set("node", (Object)map.get("node"));
            dynamicObject.set("log_no", (Object)map.get("logNo"));
            dynamicObject.set("trace_no", (Object)map.get("traceNo"));
            dynamicObject.set("bank_version", (Object)map.get("bankVersion"));
            dynamicObject.set("bank_login", (Object)map.get("bankLogin"));
            dynamicObject.set("lock_path", (Object)map.get("lockPath"));
            dynamicObject.set("status", (Object)"A");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void deleteLockInfo(String nodePath) {
        try {
            if (!this.isExisted(nodePath)) {
                QFilter filter = QFilter.of((String)"lock_path=?", (Object[])new Object[]{nodePath});
                DeleteServiceHelper.delete((String)entityName, (QFilter[])filter.toArray());
            } else {
                logger.warn("\u524d\u7f6e\u673a\u9501\u8282\u70b9\u672a\u91ca\u653e\uff0c\u5c1d\u8bd5\u91cd\u65b0\u91ca\u653e\uff1a" + nodePath);
                this.deleteNode(nodePath);
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeExpiredLock() {
        DLock lock = DLock.create((String)this.key, (String)"login_lock_monitor");
        if (lock.tryLock()) {
            try {
                EBContext context = EBContext.getContext();
                String bankLoginID = context.getBankLoginID();
                QFilter filter = QFilter.of((String)"bank_login=?", (Object[])new Object[]{bankLoginID});
                DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)properties, (QFilter[])filter.toArray());
                for (int i = 0; i < collection.size(); ++i) {
                    String timeStamp = ((DynamicObject)collection.get(i)).getString("time_stamp");
                    String nodePath = ((DynamicObject)collection.get(i)).getString("lock_path");
                    Long ts = Long.valueOf(timeStamp);
                    long timeout = 30L;
                    if (System.currentTimeMillis() - ts <= timeout * 60L * 1000L) continue;
                    if (!this.isExisted(nodePath)) {
                        this.deleteLockInfo(nodePath);
                        continue;
                    }
                    logger.info(String.format("\u524d\u7f6e\u673a\u9501\u8282\u70b9\u8d85\u65f6%s\u5206\u949f\uff0c\u51c6\u5907\u6e05\u7406zk\u8282\u70b9", timeout));
                    if (this.deleteNode(nodePath)) {
                        this.deleteLockInfo(nodePath);
                        logger.info(String.format("\u8d85\u65f6zk\u8282\u70b9\u6e05\u7406\u5b8c\u6210\uff1a%s", nodePath));
                        continue;
                    }
                    logger.info(String.format("\u8d85\u65f6zk\u8282\u70b9\u6e05\u7406\u5931\u8d25\uff1a%s", nodePath));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }
}

