/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.lock.redis;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockFactory;
import kd.bos.dlock.DLockType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBExceptionEnum;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.model.monitor.MonitorRequestInfo;
import kd.ebg.egf.common.repository.monitor.BankReqRecordRepository;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class RedisFepAccess
implements FEPAccess {
    EBGLogger logger = EBGLogger.getInstance().getLogger(RedisFepAccess.class);
    private String key;
    private long timeout = 60000L;
    private int concurrencyCount;
    private ConcurrentMap<String, DLock> leaseConcurrentMap;
    static ThreadLocal<DLock> leaseThreadLocal = new ThreadLocal();
    private static final Integer TYPE_START = 0;
    private static final Integer TYPE_END = 1;

    public RedisFepAccess(String key, int concurrencyCount) {
        String dubboTimeOut;
        this.key = key;
        this.concurrencyCount = concurrencyCount;
        if (this.concurrencyCount <= 0) {
            this.concurrencyCount = 1;
        }
        if (StringUtils.isNotEmpty(dubboTimeOut = System.getProperty("dubbo.consumer.timeout"))) {
            try {
                this.timeout = Integer.parseInt(dubboTimeOut);
            }
            catch (NumberFormatException e) {
                this.logger.warn("\u8d85\u65f6\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", e);
            }
        }
        this.leaseConcurrentMap = new ConcurrentHashMap<String, DLock>(16);
    }

    @Override
    public void lock() {
        this.record("waitTime", TYPE_START);
        DLock dLock = DLockFactory.getDLockerManager((DLockType)DLockType.redis).createLock(this.key, "Dlock of bankLogin", false);
        if (!dLock.tryLock(this.timeout)) {
            this.logger.warn("\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u7b49\u5f85\u8d85\u65f6");
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u524d\u7f6e\u673a\u9501\u8d85\u65f6\uff0c\u8d85\u65f6\u65f6\u95f4\uff1a%s\u3002", (String)"DistributedFepAccess_1", (String)"ebg-egf-common", (Object[])new Object[0]), this.timeout));
        }
        this.leaseConcurrentMap.put(Thread.currentThread().getName(), dLock);
        leaseThreadLocal.set(dLock);
        this.record("waitTime", TYPE_END);
        String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6388\u6743\u6210\u529f\uff0c%s", (String)"DistributedFepAccess_3", (String)"ebg-egf-common", (Object[])new Object[0]), this.key);
        this.logger.info(msg);
        this.record("processTime", TYPE_START);
    }

    @Override
    public void release() {
        DLock dLock = (DLock)this.leaseConcurrentMap.get(Thread.currentThread().getName());
        if (Objects.nonNull(dLock)) {
            dLock.close();
            String msg = String.format(ResManager.loadKDString((String)"\u91ca\u653e\u5206\u5e03\u5f0f\u6388\u6743\u6210\u529f\uff0c%s", (String)"DistributedFepAccess_8", (String)"ebg-egf-common", (Object[])new Object[0]), this.key);
            this.logger.info(msg);
        } else {
            dLock = leaseThreadLocal.get();
            if (Objects.nonNull(dLock)) {
                dLock.close();
                leaseThreadLocal.remove();
                this.logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u6388\u6743\u5b8c\u6210");
            } else {
                this.logger.info("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u83b7\u53d6\u6388\u6743");
            }
        }
        this.record("processTime", TYPE_END);
    }

    @Override
    public void lock(int time) {
        this.record("waitTime", TYPE_START);
        DLock dLock = DLockFactory.getDLockerManager((DLockType)DLockType.redis).createLock(this.key, "Dlock of bankLogin", false);
        long waitTime = this.timeout;
        if (time > 0 || (long)time < this.timeout) {
            waitTime = time;
        }
        if (!dLock.tryLock(waitTime)) {
            this.logger.warn("\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u7b49\u5f85\u8d85\u65f6");
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u524d\u7f6e\u673a\u9501\u8d85\u65f6\uff0c\u8d85\u65f6\u65f6\u95f4\uff1a%s\u3002", (String)"DistributedFepAccess_1", (String)"ebg-egf-common", (Object[])new Object[0]), this.timeout));
        }
        this.leaseConcurrentMap.put(Thread.currentThread().getName(), dLock);
        leaseThreadLocal.set(dLock);
        this.record("waitTime", TYPE_END);
        String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6388\u6743\u6210\u529f\uff0c%s", (String)"DistributedFepAccess_3", (String)"ebg-egf-common", (Object[])new Object[0]), this.key);
        this.logger.info(msg);
        this.record("processTime", TYPE_START);
    }

    private void record(String key, int type) {
        LocalDateTime now = LocalDateTime.now();
        Long currentTimeMillis = now.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        if (type == TYPE_START) {
            RequestContextUtils.setRunningParam(key, String.valueOf(currentTimeMillis));
            if ("waitTime".equalsIgnoreCase(key)) {
                RequestContextUtils.setRunningParam("waitLockTime", JsonUtil.toJson(now));
            }
        } else if (type == TYPE_END) {
            String lastTime = RequestContextUtils.getRunningParam(key);
            if (lastTime != null) {
                long time = currentTimeMillis - Long.parseLong(lastTime);
                RequestContextUtils.setRunningParam(key, String.valueOf(time));
                if ("waitTime".equalsIgnoreCase(key)) {
                    this.logger.info("\u7b49\u5f85\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u8017\u65f6\uff1a{} ms", (Object)time);
                } else {
                    this.logger.info("\u94f6\u884c\u8bf7\u6c42\u5904\u7406\u8017\u65f6\uff1a{} ms", (Object)time);
                }
            }
            if ("waitTime".equalsIgnoreCase(key)) {
                RequestContextUtils.setRunningParam("getLockTime", JsonUtil.toJson(now));
            } else if ("processTime".equalsIgnoreCase(key)) {
                try {
                    this.store();
                }
                catch (Throwable e) {
                    this.logger.error("\u8bb0\u5f55\u8bf7\u6c42\u7edf\u8ba1\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff1a{}", e.getMessage());
                }
            }
        }
    }

    private void store() {
        int state;
        LocalDateTime dateTime;
        EBContext context = EBContext.getContext();
        String requestID = context.getRequestSeqID();
        MonitorRequestInfo monitorRequestInfo = new MonitorRequestInfo();
        Map<String, String> map = context.getRunningParams();
        long processTime = 0L;
        long waitTime = 0L;
        if (map.containsKey("processTime")) {
            processTime = Long.parseLong(map.get("processTime"));
        }
        if (map.containsKey("waitTime")) {
            waitTime = Long.parseLong(map.get("waitTime"));
        }
        if (map.containsKey("waitLockTime")) {
            dateTime = JsonUtil.fromJson(map.get("waitLockTime"), LocalDateTime.class);
            monitorRequestInfo.setWaitLockTime(dateTime);
        }
        if (map.containsKey("getLockTime")) {
            dateTime = JsonUtil.fromJson(map.get("getLockTime"), LocalDateTime.class);
            monitorRequestInfo.setGetLockTime(dateTime);
        }
        if (EBExceptionEnum.isConnectionException(state = context.getProcessFlag()) && map.containsKey("Exception")) {
            monitorRequestInfo.setExtData(map.get("Exception"));
            monitorRequestInfo.setStatus(EBException.CONNECTION_EXCEPTION);
        }
        String bankVersion = context.getBankVersionID();
        BankLoginConfigKey key = new BankLoginConfigKey();
        key.setBankLoginId(context.getBankLoginID());
        key.setBankVersionId(bankVersion);
        key.setCustomID(context.getCustomID());
        key.setBankConfigId("leaseNum");
        int loginLockNum = 1;
        boolean isBlock = waitTime > 3000L;
        monitorRequestInfo.setRequestID(requestID);
        monitorRequestInfo.setBlockFlag(isBlock);
        monitorRequestInfo.setBlockMillis(waitTime);
        monitorRequestInfo.setProcessMillis(processTime);
        monitorRequestInfo.setCustomID(context.getCustomID());
        monitorRequestInfo.setBankVersionID(context.getBankVersionID());
        monitorRequestInfo.setBankLoginID(context.getBankLoginID());
        monitorRequestInfo.setType(context.getBizName());
        monitorRequestInfo.setLoginLockNum(loginLockNum);
        BankReqRecordRepository bankReqRecordRepository = BankReqRecordRepository.getInstance();
        bankReqRecordRepository.save(monitorRequestInfo);
    }
}

