/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.manage;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class APICipherSecurity {
    EBGLogger logger = EBGLogger.getInstance().getLogger(APICipherSecurity.class);
    private static APICipherSecurity instance = new APICipherSecurity();
    static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/PKCS5Padding";
    boolean isJDKSupportAES256 = this.testAES256();

    public static APICipherSecurity getInstance() {
        return instance;
    }

    public String encryptAES(String content, String encryptPass) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, this.getSecretKey(encryptPass));
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content.getBytes());
            assert (encryptData.length == content.getBytes().length + 16);
            byte[] message = new byte[12 + content.getBytes().length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.encodeBase64String((byte[])message);
        }
        catch (Exception e) {
            this.logger.monitorError("ebg APICipherSecurity encryptAES error: " + e.toString(), e);
            return null;
        }
    }

    public String decryptAES(String base64Content, String encryptPass) {
        byte[] content = Base64.decodeBase64((String)base64Content);
        if (content.length < 28) {
            throw new IllegalArgumentException();
        }
        GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, (Key)this.getSecretKey(encryptPass), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return StringUtils.byteToString(decryptData);
        }
        catch (Exception e) {
            this.logger.monitorError("ebg APICipherSecurity decryptAES error: " + e.toString(), e);
            throw new EBSecurityException(ResManager.loadKDString((String)"AES\u89e3\u5bc6\u5f02\u5e38", (String)"AESCipherSecurity_0", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    private SecretKeySpec getSecretKey(String encryptPass) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(encryptPass.getBytes());
        int size = this.getAESKeySize();
        kg.init(size, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), "AES");
    }

    private boolean testAES256() {
        byte[] content = "test AES 256".getBytes();
        String pass = "test_pass";
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(pass.getBytes());
            kg.init(256, secureRandom);
            SecretKey secretKey = kg.generateKey();
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, secretKeySpec);
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content);
            return encryptData.length == content.length + 16;
        }
        catch (Throwable e) {
            this.logger.monitorError("ebg APICipherSecurity test AES 256 error, jdk not support AES 256", e);
            return false;
        }
    }

    private int getAESKeySize() {
        String value = "128";
        if (this.isJDKSupportAES256) {
            String objectId = "common_business";
            String selectFields = "attr_value";
            QFilter filter = QFilter.of((String)"object_id=? and attr_key=?", (Object[])new Object[]{objectId, "AES_KEY_SIZE"});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_object_properties", (String)selectFields, (QFilter[])filter.toArray());
            value = dynamicObject != null ? dynamicObject.getString("attr_value") : "256";
        }
        return Integer.parseInt(value);
    }
}

