/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.util;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.entity.service.EBServiceRequest;
import kd.ebg.egf.common.entity.service.EBServiceResponse;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.exception.message.EBExceptionMsgEnum;
import kd.ebg.egf.common.framework.security.EBSecuritySuit;
import kd.ebg.egf.common.framework.security.api.IEBSecurityProvider;
import kd.ebg.egf.common.framework.security.atomic.IEncrypt;
import kd.ebg.egf.common.framework.security.factory.DataBaseCustomerInfoProvider;
import kd.ebg.egf.common.framework.security.factory.EBKeyProvider;
import kd.ebg.egf.common.framework.security.factory.EBSecurityProviderFactory;
import kd.ebg.egf.common.framework.security.manage.APICipherSecurity;
import kd.ebg.egf.common.framework.security.provider.CachedCustomerEcnryptKeyProvider;
import kd.ebg.egf.common.framework.security.provider.CachedCustomerEncryptKeyStorage;
import kd.ebg.egf.common.framework.security.sign.other.AlgorithmEnum;
import kd.ebg.egf.common.framework.security.util.PlainTextUtil;
import kd.ebg.egf.common.framework.service.tenant.TenantService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.tenant.CustomerInfo;
import kd.ebg.egf.common.model.tenant.TenantAuth;
import kd.ebg.egf.common.repository.tenant.TenantAuthRepository;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class EBFrontUtil {
    private static final String ebPrefix = "eb_cert_";
    static final EBGLogger logger = EBGLogger.getInstance().getLogger(EBFrontUtil.class);
    private static final EBFrontUtil instance = new EBFrontUtil();

    public static EBFrontUtil getInstance() {
        return instance;
    }

    public static void decryptReqeust(EBBaseRequest request) {
        if (!StringUtils.isEmpty(request.getEncryptKey())) {
            IEBSecurityProvider provider = EBSecurityProviderFactory.getInstance().getProvider(request);
            byte[] decryptData = provider.getEncrypt(request).decrypt(request.getData());
            request.setData(StringUtils.byte2String(decryptData));
        }
    }

    public static boolean verifyRequest(EBServiceRequest request) {
        String content = PlainTextUtil.getPlainText(request);
        byte[] data = null;
        try {
            data = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EBSecurityException(e);
        }
        byte[] publicKey = EBFrontUtil.getVerifyPubKey(request.getCustomerID());
        byte[] tempKey = EBKeyProvider.getInstance().getPrivateKey().getEncoded();
        EBSecuritySuit signature = new EBSecuritySuit(publicKey, tempKey, request.getSignAlgorithm());
        boolean flag = signature.verify(request.getSignData(), data);
        if (!flag) {
            logger.error("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u503c\uff1a" + request.getSignData());
            logger.error("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff0c\u5f85\u9a8c\u503c\uff1a" + content);
        }
        return flag;
    }

    private static byte[] getVerifyPubKey(String customerID) {
        TenantAuth tenantAuth;
        CustomerInfo info = new CustomerInfo();
        TenantAuthRepository authRepository = TenantAuthRepository.getInstance();
        List<TenantAuth> tenantAuths = EBFrontUtil.isJDY(customerID) ? authRepository.findAll() : authRepository.findByCustomID(customerID);
        if (tenantAuths.size() > 0) {
            tenantAuth = tenantAuths.get(0);
            if (tenantAuth.getExpireTime().isBefore(LocalDateTime.now())) {
                throw new EBSecurityException(EBExceptionMsgEnum.CA_CERT_EXPIRED.getErrorMsg());
            }
        } else {
            throw new EBSecurityException(EBExceptionMsgEnum.CA_CERT_EMPTY.getErrorMsg());
        }
        info.setCustomerID(customerID);
        info.setPublicKey(org.bouncycastle.util.encoders.Base64.decode((String)tenantAuth.getPublicKey()));
        info.setExpireDate(tenantAuth.getExpireTime());
        info.setCommonName(tenantAuth.getCommonName());
        info.setOrganizationalUnit(tenantAuth.getOrganization());
        return info.getPublicKey();
    }

    private static boolean isJDY(String customerID) {
        TenantService tenantService = TenantService.getInstance();
        if (tenantService.isJDY(customerID)) {
            return true;
        }
        return customerID.startsWith("JDY") || customerID.startsWith("YKJ") || customerID.startsWith("PRO");
    }

    public static boolean verifyRequest(EBServiceRequest request, String customID) {
        boolean flag = false;
        IEBSecurityProvider provider = EBSecurityProviderFactory.getInstance().getProvider(request);
        String content = PlainTextUtil.getPlainText(request);
        byte[] data = null;
        try {
            data = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EBSecurityException(e);
        }
        String original_customID = request.getCustomerID();
        request.setCustomerID(customID);
        flag = provider.getSignature(request).verify(request.getSignData(), data);
        request.setCustomerID(original_customID);
        return flag;
    }

    public static void signRequest(EBServiceRequest request) {
        IEBSecurityProvider provider = EBSecurityProviderFactory.getInstance().getProvider(request);
        String content = PlainTextUtil.getPlainText(request);
        byte[] data = null;
        try {
            data = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EBSecurityException(e);
        }
        String signData = provider.getSignature(request).sign(data);
        request.setSignData(signData);
    }

    public static void signResponse(EBServiceResponse response, EBBaseRequest request) {
        IEBSecurityProvider provider = EBSecurityProviderFactory.getInstance().getProvider(request);
        String content = PlainTextUtil.getPlainText(response);
        byte[] data = null;
        try {
            data = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EBSecurityException(e);
        }
        try {
            String signData = provider.getResponseSignature(request).sign(data);
            response.setSignData(signData);
        }
        catch (Exception e) {
            response.setSignData("");
        }
    }

    public static void encryptRequest(EBBaseRequest request) {
        IEBSecurityProvider provider = EBSecurityProviderFactory.getInstance().getProvider(request);
        byte[] data = null;
        try {
            data = request.getData().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EBSecurityException(e);
        }
        String encryptData = provider.getEncrypt(request).encrypt(data);
        request.setData(encryptData);
    }

    public static void encryptKey(EBBaseRequest request) {
        IEncrypt rsaEncrypt = EBSecurityProviderFactory.getInstance().getCustomerPublicKeyEncrypt(request.getCustomerID());
        request.setEncryptKey(rsaEncrypt.encrypt(request.getEncryptKey().getBytes()));
    }

    public static void decryptKey(EBBaseRequest request) {
        if (!StringUtils.isEmpty(request.getEncryptKey())) {
            request.setEncryptKey(org.bouncycastle.util.encoders.Base64.toBase64String((byte[])CachedCustomerEcnryptKeyProvider.getInstance().getEncryptKey(request.getEncryptKey())));
        } else {
            request.setEncryptKey(org.bouncycastle.util.encoders.Base64.toBase64String((byte[])CachedCustomerEncryptKeyStorage.getInstance().getDecryptKey(request.getToken())));
        }
    }

    public static boolean decryptAndVerifyEBSecurityRequest(EBServiceRequest request) {
        if (!StringUtils.isEmpty(request.getSignData())) {
            if (EBFrontUtil.verifyRequest(request)) {
                if (!StringUtils.isEmpty(request.getEncryptAlgorithm()) && "AES".equalsIgnoreCase(request.getEncryptAlgorithm())) {
                    EBFrontUtil.getDecryptSkey(request);
                    EBFrontUtil.getAESDecrypt(request);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static void encryptResponse(EBServiceRequest request, EBServiceResponse response) {
        if (!StringUtils.isEmpty(request.getEncryptAlgorithm()) && "AES".equalsIgnoreCase(request.getEncryptAlgorithm())) {
            CustomerInfo customerInfo = new DataBaseCustomerInfoProvider().getCustomerInfoByCustomID(request.getCustomerID());
            byte[] publicKey = customerInfo.getPublicKey();
            if (publicKey != null && !StringUtils.isEmpty(request.getEncryptKey())) {
                response.setEncryptKey(request.getEncryptKey());
                EBFrontUtil.setAESEncrypt(response);
                EBFrontUtil.setEncryptSKey(response, request.getSignAlgorithm(), publicKey);
            } else {
                response.setEncryptKey(null);
            }
        }
    }

    public static boolean decryptAndVerifyEBSecurityRequest(EBServiceRequest request, String customID) {
        if (!StringUtils.isEmpty(request.getEncryptAlgorithm())) {
            EBFrontUtil.decryptKey(request);
            EBFrontUtil.decryptReqeust(request);
        }
        return EBFrontUtil.verifyRequest(request, customID);
    }

    public static void encryptKey(EBServiceResponse response, String customerID) {
        IEncrypt rsaEncrypt = EBSecurityProviderFactory.getInstance().getCustomerPublicKeyEncrypt(customerID);
        response.setEncryptKey(rsaEncrypt.encrypt(response.getEncryptKey().getBytes()));
    }

    public static void setAESEncrypt(EBServiceResponse response) {
        String data = response.getData();
        String skey = response.getEncryptKey();
        if (skey == null) {
            logger.error("AES\u5bc6\u94a5\u4e3a\u7a7a");
            return;
        }
        if (StringUtils.isEmpty(response.getVersion())) {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                secureRandom.setSeed(skey.getBytes());
                keyGenerator.init(secureRandom);
                SecretKey secretKey = keyGenerator.generateKey();
                byte[] byteKey = secretKey.getEncoded();
                SecretKeySpec key = new SecretKeySpec(byteKey, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, key);
                byte[] result = cipher.doFinal(data.getBytes());
                data = Base64.encodeBase64String((byte[])result);
                response.setData(data);
            }
            catch (Exception keyGenerator) {}
        } else {
            APICipherSecurity security = APICipherSecurity.getInstance();
            data = security.encryptAES(data, skey);
            response.setData(data);
        }
    }

    public static void setEncryptSKey(EBServiceResponse response, String signAlgorithm, byte[] publicKey) {
        String sKey = response.getEncryptKey();
        try {
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
            Cipher cipher = EBFrontUtil.getCipher(response.getVersion(), signAlgorithm);
            cipher.init(1, pubKey);
            sKey = Base64.encodeBase64String((byte[])cipher.doFinal(sKey.getBytes("UTF-8")));
            response.setEncryptKey(sKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getDecryptSkey(EBBaseRequest request) {
        String sKey = request.getEncryptKey();
        try {
            byte[] inputByte = Base64.decodeBase64((byte[])sKey.getBytes("UTF-8"));
            byte[] privateKey = EBKeyProvider.getInstance().getPrivateKey().getEncoded();
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKey));
            Cipher cipher = EBFrontUtil.getCipher(request.getVersion(), request.getSignAlgorithm());
            cipher.init(2, priKey);
            sKey = new String(cipher.doFinal(inputByte));
            request.setEncryptKey(sKey);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6AES\u89e3\u5bc6\u79d8\u94a5\u5f02\u5e38", e);
            throw new EBSecurityException(ResManager.loadKDString((String)"\u83b7\u53d6AES\u89e3\u5bc6\u79d8\u94a5\u5f02\u5e38", (String)"EBFrontUtil_2", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    private static Cipher getCipher(String version, String signAlgorithm) throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = StringUtils.isEmpty(version) ? Cipher.getInstance("RSA") : (AlgorithmEnum.SHA256withRAS.getAlgorithm().equalsIgnoreCase(signAlgorithm) ? Cipher.getInstance("RSA/ECB/OAEPWithSHA256AndMGF1Padding") : Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding"));
        return cipher;
    }

    public static void getAESDecrypt(EBBaseRequest request) {
        String data = request.getData();
        String skey = request.getEncryptKey();
        if (StringUtils.isEmpty(request.getVersion())) {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                secureRandom.setSeed(skey.getBytes());
                keyGenerator.init(secureRandom);
                SecretKey secretKey = keyGenerator.generateKey();
                byte[] byteKey = secretKey.getEncoded();
                SecretKeySpec key = new SecretKeySpec(byteKey, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, key);
                byte[] result = cipher.doFinal(Base64.decodeBase64((byte[])data.getBytes("UTF-8")));
                data = new String(result);
                logger.info("\u89e3\u5bc6\u540e\uff1a" + data);
                request.setData(data);
            }
            catch (Exception e) {
                logger.error("\u89e3\u5bc6\u5f02\u5e38", e);
                throw new EBSecurityException(ResManager.loadKDString((String)"AES\u89e3\u5bc6\u5f02\u5e38", (String)"EBFrontUtil_3", (String)"ebg-egf-common", (Object[])new Object[0]), e);
            }
        } else {
            APICipherSecurity security = APICipherSecurity.getInstance();
            data = security.decryptAES(data, skey);
            request.setData(data);
        }
    }
}

