/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.bank;

import java.util.List;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.model.bank.login.BankLoginRel;
import kd.ebg.egf.common.repository.bank.login.BankLoginRelRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;

public class BankLoginService {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(BankLoginService.class);
    private final BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
    private static BankLoginService instance = new BankLoginService();

    public static BankLoginService getInstance() {
        return instance;
    }

    public List<BankLogin> getByCustomId(String customId) {
        return this.bankLoginRepository.findAllByCustomerID(customId);
    }

    public List<BankLogin> getNotDeleteByCustomId(String customId) {
        return this.bankLoginRepository.findAllByCustomerIDAndEnable(customId, "1");
    }

    public BankLogin getByCustomIdAndLoginId(String customId, String loginId) {
        BankLoginKey key = new BankLoginKey();
        key.setCustomId(customId);
        key.setBankLoginId(loginId);
        return this.bankLoginRepository.findById(key);
    }

    public List<BankLoginRel> getAllDetailBankLoginRel() {
        return BankLoginRelRepository.getInstance().findByConfigType(CosmicConstants.BANK_LOGIN_REL_CONFIG_TYPE_DETAIL);
    }
}

