/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.bank;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;

public class BankVersionService {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(BankVersionService.class);
    private final BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
    private final BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
    private static BankVersionService instance = new BankVersionService();

    public static BankVersionService getInstance() {
        return instance;
    }

    public List<BankListEntity> findByCustomId(String customId) {
        DynamicObject[] dynamicObjects = this.bankVersionRepository.loadEnableDynamicObjects();
        ArrayList<BankListEntity> bankVersionList = new ArrayList<BankListEntity>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            BankListEntity bankListEntity = this.toBankListInfo(dynamicObject);
            bankVersionList.add(bankListEntity);
        }
        return bankVersionList;
    }

    private BankListEntity toBankListInfo(DynamicObject dynamicObject) {
        BankListEntity bankListEntity = new BankListEntity();
        bankListEntity.setId(dynamicObject.getString("id"));
        bankListEntity.setCustomNo(dynamicObject.getString("custom_id"));
        bankListEntity.setNumber(dynamicObject.getString("number"));
        bankListEntity.setName(dynamicObject.getString("name"));
        bankListEntity.setEnable(dynamicObject.getString("enable"));
        return bankListEntity;
    }

    public DynamicObject findByAcntId(Long acntId) {
        DynamicObject acnt = this.bankAcntRepository.findById(acntId);
        return this.bankVersionRepository.loadDynamicObjectByID(acnt.getLong("group.id"));
    }
}

