/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.ebg.egf.common.log.EBGLogger;

public class NoteLicenseTask {
    private String id = UUID.randomUUID().toString();
    private String tenantId;
    private String version = "1.0";
    private String expiredDate = "1999-12-31 23:59:59";
    private int licenseCount = 0;
    private String fileType = ResManager.loadKDString((String)"\u672a\u77e5", (String)"NoteLicenseTask_0", (String)"ebg-egf-common", (Object[])new Object[0]);
    private static final Map<String, NoteLicenseTask> tasks = new ConcurrentHashMap<String, NoteLicenseTask>();
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteLicenseTask.class);

    private NoteLicenseTask(String tenantId) {
        this.tenantId = tenantId;
    }

    public static NoteLicenseTask getTask() {
        RequestContext ctx = RequestContext.get();
        String tenantId = ctx.getTenantId();
        NoteLicenseTask task = new NoteLicenseTask(tenantId);
        task.refreshLicense();
        return task;
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExpiredDate() {
        return this.expiredDate;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public String getFileType() {
        return this.fileType;
    }

    public static Map<String, NoteLicenseTask> getTasks() {
        return tasks;
    }

    private void refreshLicense() {
        this.refreshVersion();
        this.refreshLicenseCount();
        this.refreshProductInfo();
    }

    private void refreshProductInfo() {
        Date expireDate;
        String type;
        Map productInfo = LicenseServiceHelper.getProductInfo();
        logger.info("LicenseServiceHelper.getProductInfo()\u8fd4\u56de\u503c: " + productInfo);
        if (productInfo != null && (type = (String)productInfo.get("type")) != null) {
            this.fileType = type;
        }
        Map groupTimeRange = LicenseServiceHelper.getGroupTimeRange((Long)Long.parseLong("522"));
        logger.info("\u8bb8\u53ef\u5206\u7ec4id:{},\u901a\u8fc7LicenseServiceHelper.getGroupTimeRange()\u8fd4\u56de\u503c: {}", "522", groupTimeRange);
        if (groupTimeRange != null && (expireDate = (Date)groupTimeRange.get("expireDate")) != null) {
            this.expiredDate = expireDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            logger.info("\u8bb8\u53ef\u5206\u7ec4id:{} \u8fc7\u671f\u65f6\u95f4\u4e3a:{}", "522", this.expiredDate);
        }
    }

    private void refreshLicenseCount() {
        String groupId = "522";
        int i = LicenseServiceHelper.getTotalNumber((Object)groupId);
        logger.info("LicenseServiceHelper.getTotalNumber\u8fd4\u56de\u7535\u7968\u8bb8\u53ef\u6570\u91cf\u662f: " + i);
        if (i > 0) {
            this.licenseCount = i;
        }
    }

    private void refreshVersion() {
        try {
            String s = LicenseServiceHelper.getProductVersion();
            logger.info("LicenseServiceHelper.getProductVersion\u8fd4\u56de\u503c: " + s);
            if (s != null) {
                this.version = s;
            }
        }
        catch (Exception e) {
            logger.error("\u4ece\u5e73\u53f0\u83b7\u53d6\u8bb8\u53ef\u7248\u672c\u5f02\u5e38", e);
        }
    }
}

