/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import kd.ebg.egf.common.license.old.InvalidFormatException;

public class IniFile {
    Map<String, Map<String, String>> sections;
    InputStream inputStream;
    private String CHARSET = "ISO8859-1";

    public String toString() {
        return this.sections.toString();
    }

    String getProperty(String sectionName, String property) {
        return (String)this.getSection(sectionName).get(property);
    }

    String[] getPropertyValues(String sectionName, String property) {
        String tokens = this.getProperty(sectionName, property);
        if (tokens == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(tokens, ",");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i++] = st.nextToken();
        }
        return result;
    }

    Set getProperties(String sectionName) {
        return this.getSection(sectionName).keySet();
    }

    public Map getSection(String sectionName) {
        Map<String, String> section = this.sections.get(sectionName);
        return section;
    }

    public Set getSections() {
        return this.sections.keySet();
    }

    public IniFile(InputStream inputStream) throws IOException, InvalidFormatException {
        this.inputStream = inputStream;
        this.read();
    }

    void setProperty(String sectionName, String property, String value) throws IOException {
        this.getSection(sectionName).put(property, value);
    }

    private void read() throws IOException, InvalidFormatException {
        this.sections = new HashMap<String, Map<String, String>>();
        String input = null;
        HashMap<String, String> currentSection = null;
        try (InputStreamReader ir = new InputStreamReader(this.inputStream, this.CHARSET);
             LineNumberReader lnr = new LineNumberReader(ir);){
            while ((input = lnr.readLine()) != null) {
                String trimmedInput = input.trim();
                if ("".equals(trimmedInput) || trimmedInput.startsWith(";")) continue;
                if (trimmedInput.startsWith("[") && trimmedInput.endsWith("]")) {
                    String sectionName = trimmedInput.substring(1, trimmedInput.length() - 1);
                    currentSection = new HashMap<String, String>();
                    this.sections.put(sectionName, currentSection);
                    continue;
                }
                if (currentSection == null) {
                    throw new InvalidFormatException("Properties found before section at line " + lnr.getLineNumber());
                }
                int equalsAt = trimmedInput.indexOf("=");
                if (equalsAt == -1) {
                    throw new InvalidFormatException("Invalid property format at line " + lnr.getLineNumber());
                }
                String key = trimmedInput.substring(0, equalsAt);
                String value = trimmedInput.substring(equalsAt + 1);
                currentSection.put(key, value);
            }
        }
    }
}

