/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class AESUtil {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(AESUtil.class);
    private static String KI = "1234567890123456";
    private static String IV = "1234567890123456";

    public static String desEncrypt(String data, String key, String iv) {
        try {
            if (!StringUtils.checkBase64(data)) {
                return null;
            }
            byte[] encrypted1 = new Base64().decode(data);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keyspec = new SecretKeySpec(key.getBytes(), "AES");
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)keyspec, ivspec);
            byte[] original = cipher.doFinal(encrypted1);
            String originalString = new String(original);
            return originalString;
        }
        catch (Exception e) {
            logger.monitorError("ebg AES desEncrypt error: " + e.toString(), e);
            return null;
        }
    }

    public static String encrypt(String data) {
        AESCipherSecurity security = AESCipherSecurity.getInstance();
        return security.encrypt(data);
    }

    public static String desEncrypt(String data, String id) {
        AESCipherSecurity cipherSecurity = AESCipherSecurity.getInstance();
        CipherInfo cipherInfo = cipherSecurity.getCipherInfo(data);
        int version = cipherInfo.getCipherVersion();
        String plainData = "";
        if (version == 0) {
            plainData = AESUtil.desEncrypt(data, KI, IV);
            if (StringUtils.isNotEmpty(data) && StringUtils.isEmpty(plainData)) {
                return data;
            }
            AESUtil.updateCipherData(cipherSecurity, plainData, id);
        } else if (cipherSecurity.getVersion() != version) {
            plainData = cipherSecurity.decrypt(data, version);
            AESUtil.updateCipherData(cipherSecurity, plainData, id);
        } else {
            plainData = cipherSecurity.decrypt(data);
        }
        return plainData;
    }

    private static void updateCipherData(AESCipherSecurity cipherSecurity, String plainData, String id) {
        String toUpdateCipherData = cipherSecurity.encrypt(plainData);
        AESUtil.updateCipher("aqap_bank_login_config", id, "bank_config_value", toUpdateCipherData);
    }

    public static String unencryptedDesEncrypt(String data, String id) {
        if (StringUtils.isEmpty(data)) {
            return data;
        }
        String result = null;
        try {
            result = AESUtil.desEncrypt(data, id);
        }
        catch (Exception e) {
            return data;
        }
        return result != null ? result.trim() : data;
    }

    private static void updateCipher(String entity, String id, String column, String toUpdateCipherData) {
        try {
            QFilter filter = QFilter.of((String)"id=? and custom_id=?", (Object[])new Object[]{Long.parseLong(id), RequestContext.get().getTenantId()});
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)entity, (String)column, (QFilter[])filter.toArray());
            object.set(column, (Object)toUpdateCipherData);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{object});
        }
        catch (Exception e) {
            logger.error(e.toString(), e);
        }
    }
}

