/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.zookeeper.cluster;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.PropertiesUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.client.CuratorZookeeperClient;
import kd.ebg.egf.common.zookeeper.cluster.URL;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.zookeeper.data.Stat;

public class ClusterManager {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ClusterManager.class);
    private static ClusterManager instance = new ClusterManager();
    private static final String SEMAPHORE_NODE = "/semaphore";
    private CuratorZookeeperClient zookeeperClient;
    private CuratorFramework curatorFramework;
    private ConcurrentMap<String, InterProcessSemaphoreV2> semaphoreCache = Maps.newConcurrentMap();

    public static ClusterManager getInstance() {
        return instance;
    }

    public ClusterManager() {
        String value;
        boolean isRemoveZK;
        if (StringUtils.isNotEmpty(System.getProperty("configUrl")) && !(isRemoveZK = Boolean.parseBoolean(value = PropertiesUtils.getValue("isRomveZK")))) {
            this.init();
        }
    }

    private synchronized void init() {
        try {
            if (this.zookeeperClient == null) {
                String host = System.getProperty("configUrl");
                Map<String, String> parameterMap = this.getUrlParameters(host);
                host = parameterMap.get("hostUrl");
                String user = parameterMap.get("user");
                String cipher = parameterMap.get("password");
                URL url = new URL(user, cipher, host, "ebgservice", null);
                this.zookeeperClient = new CuratorZookeeperClient(url);
            }
            this.curatorFramework = this.zookeeperClient.getCuratorFramework();
            if (this.curatorFramework == null) {
                this.logger.error("curatorFramework \u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5b9e\u4f8b\u5316ClusterManager\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
    }

    public InterProcessSemaphoreV2 getSemaphore(String nodeKey, int maxSize) {
        if (!Strings.isNullOrEmpty((String)nodeKey)) {
            if (this.curatorFramework == null) {
                this.init();
            }
            InterProcessSemaphoreV2 v2 = new InterProcessSemaphoreV2(this.curatorFramework, "/semaphore/" + nodeKey, maxSize);
            this.semaphoreCache.putIfAbsent(nodeKey, v2);
        }
        return (InterProcessSemaphoreV2)this.semaphoreCache.get(nodeKey);
    }

    public boolean isConnection() {
        return this.zookeeperClient.isConnected();
    }

    public void close() {
        this.zookeeperClient.close();
    }

    public boolean isExistedNode(String nodePath) {
        try {
            Stat stat = (Stat)this.zookeeperClient.getCuratorFramework().checkExists().forPath(nodePath);
            return stat != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteNode(String nodePath) {
        try {
            this.zookeeperClient.getCuratorFramework().delete().forPath(nodePath);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setNodeValue(String nodePath) {
        String currentTime = String.valueOf(System.currentTimeMillis());
        try {
            byte[] val = currentTime.getBytes(Charset.forName("UTF-8"));
            this.zookeeperClient.getCuratorFramework().setData().forPath(nodePath, val);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNodeValue(String nodePath, String value) {
        try {
            byte[] val = value.getBytes(Charset.forName("UTF-8"));
            this.zookeeperClient.getCuratorFramework().setData().forPath(nodePath, val);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getNodeValue(String nodePath) {
        String result = "";
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(nodePath);
            String path = sb.toString();
            byte[] value = (byte[])this.zookeeperClient.getCuratorFramework().getData().forPath(path);
            if (value != null) {
                result = StringUtils.byteToString(value);
            }
        }
        catch (Exception e) {
            result = "";
        }
        return result;
    }

    private Map<String, String> getUrlParameters(String url) {
        HashMap<String, String> parameterMap = new HashMap<String, String>(16);
        if (StringUtils.isNotEmpty(url)) {
            String[] arrSplit = url.split("[?]");
            String hostUrl = arrSplit[0];
            Pattern pattern = Pattern.compile("[0-9]*");
            for (int i = hostUrl.length(); i > 0; --i) {
                StringBuilder sb = new StringBuilder();
                sb.append(hostUrl.charAt(i - 1));
                Matcher isNum = pattern.matcher(sb.toString());
                if (!isNum.matches()) continue;
                hostUrl = hostUrl.substring(0, i);
                break;
            }
            parameterMap.put("hostUrl", hostUrl);
            if (arrSplit.length > 1 && arrSplit[1] != null) {
                String[] paramSplit = arrSplit[1].split("[&]");
                for (int i = 0; i < paramSplit.length; ++i) {
                    String[] parameters = paramSplit[i].split("[=]");
                    if (parameters.length <= 1) continue;
                    parameterMap.put(parameters[0], parameters[1]);
                }
            }
        }
        return parameterMap;
    }

    public boolean checkNodeExist(String path) {
        return this.zookeeperClient.checkNodeExist(path);
    }

    public void createNode(String path) {
        if (!this.checkNodeExist(path)) {
            this.zookeeperClient.create(path, "", false);
        }
    }
}

