/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.async;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.common.framework.async.DefaultThreadFactory;

public class BankLoginThreadPoolManager {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankLoginThreadPoolManager.class);
    private static final Map<String, ThreadPoolExecutor> bankThreadPool = new ConcurrentHashMap<String, ThreadPoolExecutor>(50);

    private static synchronized ThreadPoolExecutor ensureExist(String bankVersionID, final String bankLoginID) {
        ThreadPoolExecutor executor = bankThreadPool.get(bankLoginID);
        if (Objects.isNull(executor)) {
            int concurrentCount = 5;
            executor = new ThreadPoolExecutor(concurrentCount, concurrentCount, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(200), new DefaultThreadFactory("", bankLoginID), new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    log.warn("\u94f6\u884c\u524d\u7f6e\u673a{}\u5904\u7406\u961f\u5217\u5df2\u6ee1\uff0c\u5f53\u524d\u6d3b\u8dc3\u7ebf\u7a0b\uff1a{}\uff0c\u4efb\u52a1\u6570\uff1a{}\uff0c\u5f53\u524d\u961f\u5217\u5927\u5c0f\uff1a{}", new Object[]{bankLoginID, executor.getActiveCount(), executor.getTaskCount(), executor.getQueue().size()});
                }
            });
            bankThreadPool.put(bankLoginID, executor);
        }
        return executor;
    }

    public static ThreadPoolExecutor getThreadPoolExecutor(String bankVersionID, String bankLoginID) {
        ThreadPoolExecutor threadPoolExecutor = bankThreadPool.get(bankLoginID);
        if (Objects.isNull(threadPoolExecutor)) {
            threadPoolExecutor = BankLoginThreadPoolManager.ensureExist(bankVersionID, bankLoginID);
        }
        return threadPoolExecutor;
    }
}

