/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.async;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.krpc.common.utils.ConcurrentHashSet;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.common.framework.async.BankLoginThreadPoolManager;
import kd.ebg.note.common.framework.async.BankTask;
import kd.ebg.note.common.framework.async.BankTaskResult;
import kd.ebg.note.common.framework.async.BankTaskWorker;
import kd.ebg.note.common.framework.async.IBankTaskExecutor;
import kd.ebg.note.common.framework.async.IProcess;
import kd.ebg.note.common.framework.async.utils.ProcessFactory;

@Component
public class DefaultBankTaskExecutor
implements IBankTaskExecutor {
    EBGLogger log = EBGLogger.getInstance().getLogger(DefaultBankTaskExecutor.class);
    private static final String runningTaskCount = "application.executor.running";
    private static final String totalTaskCount = "application.executor.total";
    private ConcurrentHashMap<String, Future<BankTaskResult>> runningTasks;
    private ConcurrentHashSet<String> taskIds;
    private AtomicInteger totalCount = new AtomicInteger();

    public DefaultBankTaskExecutor() {
        this.runningTasks = new ConcurrentHashMap(20);
        this.taskIds = new ConcurrentHashSet(20);
    }

    private IProcess preCheck(BankTask bankTask) {
        String id = bankTask.getId();
        Preconditions.checkArgument((boolean)Objects.nonNull(bankTask), (Object)ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5f02\u6b65\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DefaultBankTaskExecutor_0", (String)"ebg-note-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(id), (Object)ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5f02\u6b65\u4efb\u52a1\u552f\u4e00id\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DefaultBankTaskExecutor_1", (String)"ebg-note-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(bankTask.getRequest()), (Object)ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5f02\u6b65\u4efb\u52a1\uff0c\u5177\u4f53\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DefaultBankTaskExecutor_2", (String)"ebg-note-common", (Object[])new Object[0]));
        BankRequest request = bankTask.getRequest();
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"request \u4e3a\u7a7a\u3002", (String)"DefaultBankTaskExecutor_3", (String)"ebg-note-common", (Object[])new Object[0]));
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)ResManager.loadKDString((String)"request.header \u4e3a\u7a7a\u3002", (String)"DefaultBankTaskExecutor_4", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        IProcess process = ProcessFactory.getInstance().getProcess(request);
        Preconditions.checkArgument((boolean)Objects.nonNull(process), (Object)ResManager.loadKDString((String)"process \u4e3a\u7a7a\u3002", (String)"DefaultBankTaskExecutor_5", (String)"ebg-note-common", (Object[])new Object[0]));
        return process;
    }

    @Override
    public Future<BankTaskResult> asyncInvoke(BankTask bankTask, boolean needResult) {
        IProcess process = this.preCheck(bankTask);
        String id = bankTask.getId();
        BankRequest request = bankTask.getRequest();
        String bankLoginID = request.getHeader().getBankLoginID();
        String bankVersionID = request.getHeader().getBankVersionID();
        this.log.info("\u6821\u9a8c\u6210\u529f\uff0c\u51c6\u5907\u83b7\u53d6\u7ebf\u7a0b\u6c60");
        ThreadPoolExecutor executor = BankLoginThreadPoolManager.getThreadPoolExecutor(bankVersionID, bankLoginID);
        Future<BankTaskResult> resultFuture = executor.submit(new BankTaskWorker(process, bankTask));
        this.log.info("\u63d0\u4ea4\u6210\u529f");
        this.taskIds.add((Object)id);
        if (needResult) {
            this.runningTasks.put(id, resultFuture);
            return resultFuture;
        }
        return null;
    }

    @Override
    public BankTaskResult syncInvoke(BankTask bankTask) {
        this.totalCount.incrementAndGet();
        Future<BankTaskResult> resultFuture = this.asyncInvoke(bankTask, true);
        if (Objects.nonNull(resultFuture)) {
            try {
                return resultFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.log.warn("\u540c\u6b65\u8c03\u7528\u7b49\u5f85\u7ed3\u679c\u8fc7\u7a0b\u4e2d\u5f02\u5e38", new Object[]{e});
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9e\u73b0\u9519\u8bef\uff0c\u8c03\u7528\u540e\u6ca1\u8fd4\u56de Future \u3002 ", (String)"DefaultBankTaskExecutor_6", (String)"ebg-note-common", (Object[])new Object[0]));
    }

    @Override
    public BankTaskResult directInvoke(BankTask bankTask) {
        this.totalCount.incrementAndGet();
        IProcess process = this.preCheck(bankTask);
        String id = bankTask.getId();
        this.taskIds.add((Object)id);
        BankTaskWorker worker = new BankTaskWorker(process, bankTask);
        try {
            return worker.call();
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    @Override
    public boolean containsTaskId(String taskId) {
        return this.taskIds.contains((Object)taskId);
    }

    @Override
    public void removeTaskId(String taskId) {
        this.taskIds.remove((Object)taskId);
        if (!this.runningTasks.isEmpty() && this.runningTasks.containsKey(taskId)) {
            this.runningTasks.remove(taskId);
        }
    }

    @Override
    public IBankTaskExecutor.Status status() {
        if (this.taskIds.size() < 5) {
            return IBankTaskExecutor.Status.FREE;
        }
        if (this.taskIds.size() < 20) {
            return IBankTaskExecutor.Status.NORMAL;
        }
        return IBankTaskExecutor.Status.BUSY;
    }
}

