/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.bank.meta.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.note.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.note.common.framework.bank.meta.BankMetaDataInfo;
import kd.ebg.note.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.note.common.framework.properties.BankPropertyConfig;

public abstract class FBEMetaDataTemplate
extends BankMetaDataInfo
implements BankMetaDataCollector {
    @Override
    public BankVersionMetaInfo getBankVersionMetaInfo() {
        this.metaDataInit();
        String key = this.bankShortName + "_concurrentCount";
        int concurrentCount = 0;
        try {
            String property = System.getProperty(key);
            if (!StringUtils.isEmpty((String)property)) {
                concurrentCount = Integer.parseInt(property);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BankVersionMetaInfo.builder().bankShortName(this.bankShortName).bankName(this.bankName).bankVersionID(this.bankVersionID).bankVersionName(this.bankVersionName).description(this.description).keyNames(this.keyNames).concurrentCount(concurrentCount).build();
    }

    @Override
    public List<BankLoginConfig> getBankLoginConfig() {
        this.baseConfigInit();
        ArrayList<BankLoginConfig> bankLoginConfig = new ArrayList<BankLoginConfig>();
        List<BankLoginConfig> configs = this.getBankFrontConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getFrontProxyConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PROXY_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginExtraConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.EXTRA_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        if (this.showAchieveWay()) {
            configs = this.getBankLoginReceiptAchieveWayConfig();
            for (BankLoginConfig config : configs) {
                config.setType(MetaDataConfigType.RECEIPT_ACHIEVEWAY_CONFIG.getName());
            }
            bankLoginConfig.addAll(configs);
        }
        configs = this.getBankLoginReceiptBaseConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        return bankLoginConfig;
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return null;
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)"ip", (String)ResManager.loadKDString((String)"\u524d\u7f6e\u673aIP\u5730\u5740", (String)"FBEMetaDataTemplate_0", (String)"ebg-note-common", (Object[])new Object[0]), (String)this.host, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"exchangePort", (String)ResManager.loadKDString((String)"\u7aef\u53e3\u53f7", (String)"FBEMetaDataTemplate_1", (String)"ebg-note-common", (Object[])new Object[0]), (String)this.port, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"exchangeProtocol", (String)ResManager.loadKDString((String)"\u901a\u8baf\u534f\u8bae", (String)"FBEMetaDataTemplate_2", (String)"ebg-note-common", (Object[])new Object[0]), (String)this.protocol).set2ReadOnly(), BankLoginConfigUtil.getBankLoginConfig((String)"timeout", (String)ResManager.loadKDString((String)"\u8d85\u65f6\u8bbe\u7f6e(min)", (String)"FBEMetaDataTemplate_3", (String)"ebg-note-common", (Object[])new Object[0]), (String)String.valueOf(this.timeout)), BankLoginConfigUtil.getBankLoginConfig((String)"charset", (String)ResManager.loadKDString((String)"\u5b57\u7b26\u96c6", (String)"FBEMetaDataTemplate_4", (String)"ebg-note-common", (Object[])new Object[0]), (String)this.charset).set2ReadOnly()});
    }

    public List<BankLoginConfig> getFrontProxyConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginReceiptAchieveWayConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginReceiptBaseConfig() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return null;
    }

    @Override
    public boolean showInJdy() {
        return false;
    }
}

