/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import kd.ebg.note.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.note.common.framework.properties.PropertyChecker;
import kd.ebg.note.common.framework.properties.PropertyConfig;

public class PropertyConfigItem {
    @JsonIgnore
    private transient PropertyConfig _propertyConfig;
    String originalOwner;
    private String key;
    private String name;
    private String desc;
    private String type;
    private boolean mustInput;
    private int minValueNum = 1;
    private int maxValueNum = 1;
    private List<PropertyChecker> checkers;
    private List<String> sourceNames;
    private List<String> sourceValues;
    private List<String> defaultValues;
    private boolean readonly;
    private boolean isAccNo;

    @JsonIgnore
    public String getCurrentValue() {
        return GlobalPropertyConfig.getInstance().getConfigValue(this);
    }

    public void setCurrentValues(List<String> values) {
        GlobalPropertyConfig.getInstance().setConfigValues(this, values);
    }

    @JsonIgnore
    public List<String> getCurrentValues() {
        return GlobalPropertyConfig.getInstance().getConfigValues(this);
    }

    @JsonIgnore
    public String getCurrentValueWithObjectID(String objectID) {
        return GlobalPropertyConfig.getInstance().getConfigValue(this, objectID);
    }

    @JsonIgnore
    public List<String> getCurrentValuesWithObjectID(String objectID) {
        return GlobalPropertyConfig.getInstance().getConfigValues(this, objectID);
    }

    @JsonIgnore
    public boolean getCurrentValueAsBoolean() {
        String currentValue = this.getCurrentValue();
        return "on".equalsIgnoreCase(currentValue) || Boolean.parseBoolean(this.getCurrentValue());
    }

    @JsonIgnore
    public int getCurrentValueAsInt() {
        return Integer.parseInt(this.getCurrentValue());
    }

    public PropertyConfig get_propertyConfig() {
        return this._propertyConfig;
    }

    public void set_propertyConfig(PropertyConfig _propertyConfig) {
        this._propertyConfig = _propertyConfig;
    }

    public String getOriginalOwner() {
        return this.originalOwner;
    }

    public void setOriginalOwner(String originalOwner) {
        this.originalOwner = originalOwner;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean mustInput) {
        this.mustInput = mustInput;
    }

    public int getMinValueNum() {
        return this.minValueNum;
    }

    public void setMinValueNum(int minValueNum) {
        this.minValueNum = minValueNum;
    }

    public int getMaxValueNum() {
        return this.maxValueNum;
    }

    public void setMaxValueNum(int maxValueNum) {
        this.maxValueNum = maxValueNum;
    }

    public List<PropertyChecker> getCheckers() {
        return this.checkers;
    }

    public void setCheckers(List<PropertyChecker> checkers) {
        this.checkers = checkers;
    }

    public List<String> getSourceNames() {
        return this.sourceNames;
    }

    public void setSourceNames(List<String> sourceNames) {
        this.sourceNames = sourceNames;
    }

    public List<String> getSourceValues() {
        return this.sourceValues;
    }

    public void setSourceValues(List<String> sourceValues) {
        this.sourceValues = sourceValues;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(List<String> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isAccNo() {
        return this.isAccNo;
    }

    public void setAccNo(boolean accNo) {
        this.isAccNo = accNo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String key;
        String name;
        String desc;
        List<String> sourceNames;
        List<String> sourceValues;
        List<String> defaultValues;
        int minValueNum;
        int maxValueNum;
        List<PropertyChecker> checkers;
        String type;
        boolean mustInput;
        boolean accNo;
        boolean readonly;

        public Builder key(String value) {
            this.key = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder desc(String value) {
            this.desc = value;
            return this;
        }

        public Builder sourceNames(List<String> value) {
            this.sourceNames = value;
            return this;
        }

        public Builder sourceValues(List<String> value) {
            this.sourceValues = value;
            return this;
        }

        public Builder defaultValues(List<String> value) {
            this.defaultValues = value;
            return this;
        }

        public Builder minValueNum(int value) {
            this.minValueNum = value;
            return this;
        }

        public Builder maxValueNum(int value) {
            this.maxValueNum = value;
            return this;
        }

        public Builder checkers(List<PropertyChecker> checkers) {
            this.checkers = checkers;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder mustInput(boolean mustInput) {
            this.mustInput = mustInput;
            return this;
        }

        public Builder isAccNo(boolean accNo) {
            this.accNo = accNo;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public PropertyConfigItem build() {
            PropertyConfigItem propertyConfigItem = new PropertyConfigItem();
            propertyConfigItem.setKey(this.key);
            propertyConfigItem.setName(this.name);
            propertyConfigItem.setDesc(this.desc);
            propertyConfigItem.setSourceNames(this.sourceNames);
            propertyConfigItem.setSourceValues(this.sourceValues);
            propertyConfigItem.setDefaultValues(this.defaultValues);
            propertyConfigItem.setMinValueNum(this.minValueNum);
            propertyConfigItem.setMaxValueNum(this.maxValueNum);
            propertyConfigItem.setCheckers(this.checkers);
            propertyConfigItem.setType(this.type);
            propertyConfigItem.setMustInput(this.mustInput);
            propertyConfigItem.setAccNo(this.accNo);
            propertyConfigItem.setReadonly(this.readonly);
            return propertyConfigItem;
        }
    }
}

