/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.model.repository;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.transform.NotePayableTransFormer;

@Component
public class NotePayableInfoRepository {
    EBGLogger log = EBGLogger.getInstance().getLogger(NotePayableInfoRepository.class);
    private final String PAYABLE_ENTITY = "note_payable";
    private final String SELECT_ALL_PROPERTIES = "status,id,ebg_id,version,custom_id,bank_version_id,bank_login_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,bill_no,amount,currency,draft_type,transfer_flag,keep_flag,contract_no,invoice_no,contract_obj,auto_accept,auto_receive,booking_date,due_date,issue_date,note_status,other_info,operation_code,operation_name,explanation,drawer_acc_no,drawer_acc_name,drawer_bank_cnaps,drawer_bank_name,drawer_bank_address,drawer_acc_country,drawer_acc_province,drawer_acc_city,drawer_ratings,drawer_agency,drawer_due_date,acceptor_acc_no,acceptor_acc_name,acceptor_bank_cnaps,acceptor_bank_name,acceptor_bank_address,acceptor_acc_country,acceptor_acc_province,acceptor_acc_city,payee_acc_no,payee_acc_name,payee_bank_name,payee_bank_cnaps,payee_bank_address,payee_country,payee_province,payee_city,status_name,status_msg,bank_status,bank_msg,error_msg,bak_status,bak_status_name,bak_status_msg,bak_bank_status,bak_bank_msg,bak_error_msg,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_seq,submit_count,submit_success_time,last_sync_time,last_sync_request_seq,sync_count,pay_finish_time,to_give_up,obssid,query_type,sequence,reserved2,reserved3,reserved4,reserved1,rqstserialno,rspserialno,isnewecds,grdbag,startno,endno,cirstatus,bankrefdate,bankrefkey,subrange,totalsize,isacceptsamebank,ispayeesamebank ,draftamount,batchtotalamount,isrefuse,acceptor_org,payee_org";

    public List<NotePayableInfo> findByBatchSeqId(String batchSeqId) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqId});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"note_payable", (String)"status,id,ebg_id,version,custom_id,bank_version_id,bank_login_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,bill_no,amount,currency,draft_type,transfer_flag,keep_flag,contract_no,invoice_no,contract_obj,auto_accept,auto_receive,booking_date,due_date,issue_date,note_status,other_info,operation_code,operation_name,explanation,drawer_acc_no,drawer_acc_name,drawer_bank_cnaps,drawer_bank_name,drawer_bank_address,drawer_acc_country,drawer_acc_province,drawer_acc_city,drawer_ratings,drawer_agency,drawer_due_date,acceptor_acc_no,acceptor_acc_name,acceptor_bank_cnaps,acceptor_bank_name,acceptor_bank_address,acceptor_acc_country,acceptor_acc_province,acceptor_acc_city,payee_acc_no,payee_acc_name,payee_bank_name,payee_bank_cnaps,payee_bank_address,payee_country,payee_province,payee_city,status_name,status_msg,bank_status,bank_msg,error_msg,bak_status,bak_status_name,bak_status_msg,bak_bank_status,bak_bank_msg,bak_error_msg,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_seq,submit_count,submit_success_time,last_sync_time,last_sync_request_seq,sync_count,pay_finish_time,to_give_up,obssid,query_type,sequence,reserved2,reserved3,reserved4,reserved1,rqstserialno,rspserialno,isnewecds,grdbag,startno,endno,cirstatus,bankrefdate,bankrefkey,subrange,totalsize,isacceptsamebank,ispayeesamebank ,draftamount,batchtotalamount,isrefuse,acceptor_org,payee_org", (QFilter[])filter.toArray());
        ArrayList<NotePayableInfo> paymentInfos = new ArrayList<NotePayableInfo>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            paymentInfos.add(NotePayableTransFormer.getInstance().packNotePayable(dynamicObject));
        }
        return paymentInfos;
    }

    public long countByBatchSeqId(String batchSeqId) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqId});
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"note_payable", (String)"id", (QFilter[])filter.toArray(), (String)"");
        long total = ds.count("id", false);
        return total;
    }

    public List<NotePayableInfo> findByBankBatchSeqId(String bankBatchSeqId) {
        QFilter filter = QFilter.of((String)"bank_batch_seq_id = ?", (Object[])new Object[]{bankBatchSeqId});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"note_payable", (String)"status,id,ebg_id,version,custom_id,bank_version_id,bank_login_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,bill_no,amount,currency,draft_type,transfer_flag,keep_flag,contract_no,invoice_no,contract_obj,auto_accept,auto_receive,booking_date,due_date,issue_date,note_status,other_info,operation_code,operation_name,explanation,drawer_acc_no,drawer_acc_name,drawer_bank_cnaps,drawer_bank_name,drawer_bank_address,drawer_acc_country,drawer_acc_province,drawer_acc_city,drawer_ratings,drawer_agency,drawer_due_date,acceptor_acc_no,acceptor_acc_name,acceptor_bank_cnaps,acceptor_bank_name,acceptor_bank_address,acceptor_acc_country,acceptor_acc_province,acceptor_acc_city,payee_acc_no,payee_acc_name,payee_bank_name,payee_bank_cnaps,payee_bank_address,payee_country,payee_province,payee_city,status_name,status_msg,bank_status,bank_msg,error_msg,bak_status,bak_status_name,bak_status_msg,bak_bank_status,bak_bank_msg,bak_error_msg,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_seq,submit_count,submit_success_time,last_sync_time,last_sync_request_seq,sync_count,pay_finish_time,to_give_up,obssid,query_type,sequence,reserved2,reserved3,reserved4,reserved1,rqstserialno,rspserialno,isnewecds,grdbag,startno,endno,cirstatus,bankrefdate,bankrefkey,subrange,totalsize,isacceptsamebank,ispayeesamebank ,draftamount,batchtotalamount,isrefuse,acceptor_org,payee_org", (QFilter[])filter.toArray());
        ArrayList<NotePayableInfo> paymentInfos = new ArrayList<NotePayableInfo>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            paymentInfos.add(NotePayableTransFormer.getInstance().packNotePayable(dynamicObject));
        }
        return paymentInfos;
    }

    public List<NotePayableInfo> selectByBillno(String billno) {
        QFilter filter = QFilter.of((String)"bill_no = ? and sub_biz_type = ?", (Object[])new Object[]{billno, "remit_register"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"note_payable", (String)"status,id,ebg_id,version,custom_id,bank_version_id,bank_login_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,bill_no,amount,currency,draft_type,transfer_flag,keep_flag,contract_no,invoice_no,contract_obj,auto_accept,auto_receive,booking_date,due_date,issue_date,note_status,other_info,operation_code,operation_name,explanation,drawer_acc_no,drawer_acc_name,drawer_bank_cnaps,drawer_bank_name,drawer_bank_address,drawer_acc_country,drawer_acc_province,drawer_acc_city,drawer_ratings,drawer_agency,drawer_due_date,acceptor_acc_no,acceptor_acc_name,acceptor_bank_cnaps,acceptor_bank_name,acceptor_bank_address,acceptor_acc_country,acceptor_acc_province,acceptor_acc_city,payee_acc_no,payee_acc_name,payee_bank_name,payee_bank_cnaps,payee_bank_address,payee_country,payee_province,payee_city,status_name,status_msg,bank_status,bank_msg,error_msg,bak_status,bak_status_name,bak_status_msg,bak_bank_status,bak_bank_msg,bak_error_msg,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_seq,submit_count,submit_success_time,last_sync_time,last_sync_request_seq,sync_count,pay_finish_time,to_give_up,obssid,query_type,sequence,reserved2,reserved3,reserved4,reserved1,rqstserialno,rspserialno,isnewecds,grdbag,startno,endno,cirstatus,bankrefdate,bankrefkey,subrange,totalsize,isacceptsamebank,ispayeesamebank ,draftamount,batchtotalamount,isrefuse,acceptor_org,payee_org", (QFilter[])filter.toArray());
        ArrayList<NotePayableInfo> paymentInfos = new ArrayList<NotePayableInfo>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            paymentInfos.add(NotePayableTransFormer.getInstance().packNotePayable(dynamicObject));
        }
        return paymentInfos;
    }

    public void findById(String id) {
    }

    public List<NotePayableInfo> save(List<NotePayableInfo> notePayableInfos) {
        ArrayList<NotePayableInfo> insertList = new ArrayList<NotePayableInfo>();
        ArrayList<NotePayableInfo> updateList = new ArrayList<NotePayableInfo>();
        for (NotePayableInfo info : notePayableInfos) {
            Long id = info.getId();
            if (QueryServiceHelper.exists((String)"note_payable", (Object)id)) {
                updateList.add(info);
                continue;
            }
            insertList.add(info);
        }
        this.insertAll(insertList);
        this.updateAll(updateList);
        return notePayableInfos;
    }

    public void insertAll(List<NotePayableInfo> Infos) {
        if (Infos.size() > 0) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Infos.size());
            for (NotePayableInfo paymentInfo : Infos) {
                dynamicObjectList.add(NotePayableTransFormer.getInstance().transNotePayable(paymentInfo));
            }
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[Infos.size()]);
            this.log.info("\u5f85\u63d2\u5165\u5e94\u4ed8\u7968\u636e\u8bb0\u5f55\uff1a{}\u6761", (Object)Infos.size());
            try {
                Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                for (int i = 0; i < objs.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)objs[i];
                    Infos.get(i).setId(dynamicObject.getLong("id"));
                }
                this.log.info("\u4ed8\u6b3e\u8bb0\u5f55\u63d2\u5165\u5b8c\u6210");
            }
            catch (Exception e) {
                this.log.error("\u4ed8\u6b3e\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
    }

    public void updateAll(List<NotePayableInfo> paymentInfos) {
        if (paymentInfos.size() > 0) {
            try {
                ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(paymentInfos.size());
                for (NotePayableInfo paymentInfo : paymentInfos) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"note_payable");
                    dynamicObjectList.add(NotePayableTransFormer.getInstance().transNotePayable(dynamicObject, paymentInfo));
                }
                DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[paymentInfos.size()]);
                this.log.info("\u5f85\u66f4\u65b0\u4ed8\u6b3e\u8bb0\u5f55\uff1a{}\u6761", (Object)paymentInfos.size());
                NotePayableTransFormer.getInstance().updateWithVersion(dynamicObjects, paymentInfos);
                this.log.info("\u4ed8\u6b3e\u8bb0\u5f55\u66f4\u65b0\u5b8c\u6210");
            }
            catch (Exception e) {
                this.log.error("\u4ed8\u6b3e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff1a", (Throwable)e);
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
    }

    public NotePayableInfo save(NotePayableInfo notePayableInfos) {
        Long id = notePayableInfos.getId();
        ArrayList<NotePayableInfo> insertList = new ArrayList<NotePayableInfo>();
        ArrayList<NotePayableInfo> updateList = new ArrayList<NotePayableInfo>();
        if (QueryServiceHelper.exists((String)"note_payable", (Object)id)) {
            updateList.add(notePayableInfos);
        } else {
            insertList.add(notePayableInfos);
        }
        this.insertAll(insertList);
        this.updateAll(updateList);
        return notePayableInfos;
    }

    public List<NotePayableInfo> findByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ? and detail_seq_id = ?", (Object[])new Object[]{batchSeqID, detailSeqID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"note_payable", (String)"status,id,ebg_id,version,custom_id,bank_version_id,bank_login_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,bill_no,amount,currency,draft_type,transfer_flag,keep_flag,contract_no,invoice_no,contract_obj,auto_accept,auto_receive,booking_date,due_date,issue_date,note_status,other_info,operation_code,operation_name,explanation,drawer_acc_no,drawer_acc_name,drawer_bank_cnaps,drawer_bank_name,drawer_bank_address,drawer_acc_country,drawer_acc_province,drawer_acc_city,drawer_ratings,drawer_agency,drawer_due_date,acceptor_acc_no,acceptor_acc_name,acceptor_bank_cnaps,acceptor_bank_name,acceptor_bank_address,acceptor_acc_country,acceptor_acc_province,acceptor_acc_city,payee_acc_no,payee_acc_name,payee_bank_name,payee_bank_cnaps,payee_bank_address,payee_country,payee_province,payee_city,status_name,status_msg,bank_status,bank_msg,error_msg,bak_status,bak_status_name,bak_status_msg,bak_bank_status,bak_bank_msg,bak_error_msg,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_seq,submit_count,submit_success_time,last_sync_time,last_sync_request_seq,sync_count,pay_finish_time,to_give_up,obssid,query_type,sequence,reserved2,reserved3,reserved4,reserved1,rqstserialno,rspserialno,isnewecds,grdbag,startno,endno,cirstatus,bankrefdate,bankrefkey,subrange,totalsize,isacceptsamebank,ispayeesamebank ,draftamount,batchtotalamount,isrefuse,acceptor_org,payee_org", (QFilter[])filter.toArray());
        ArrayList<NotePayableInfo> paymentInfos = new ArrayList<NotePayableInfo>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            paymentInfos.add(NotePayableTransFormer.getInstance().packNotePayable(dynamicObject));
        }
        return paymentInfos;
    }
}

