/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.model.repository;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.note.common.model.CertInfo;

@Component
public class UserCertRepository {
    private static final String ENTITY_NAME = "aqap_bd_cert";

    public CertInfo findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(String bankConfigId, String bankLoginID, String customID) {
        String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, acnt_no, type, cert_type, custom_id, file_name, expire_time, modifytime, is_alert, alert_day, cert_password, cert_source";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_config_id", "=", (Object)bankConfigId), new QFilter("bank_login_id", "=", (Object)bankLoginID), new QFilter("custom_id", "=", (Object)customID), new QFilter("type", "=", (Object)CertType.BANKLOGIN_CER)});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            CertInfo certInfo = new CertInfo();
            certInfo.setFileContent(dynamicObject.getString("bank_config_value_tag"));
            certInfo.setCustomID(customID);
            certInfo.setCertPassword(dynamicObject.getString("cert_password"));
            return certInfo;
        }
        return null;
    }

    public DynamicObject[] getBankLoginCerDatas(String bankLoginID, String customID) {
        String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, acnt_no, type, custom_id, file_name";
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_login_id", "=", (Object)bankLoginID), new QFilter("custom_id", "=", (Object)customID), new QFilter("type", "=", (Object)CertType.BANKLOGIN_CER.getType())});
    }
}

