/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.receivable.payment;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryNoteReceivableImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        LoginUtils.login();
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        NoteReceivableInfo info = receivableInfos[0];
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEQ528", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomExtUtils.addChildCDData(common, "ExgBill_Plc_Bl_CtCd", info.getDraftType());
        JDomExtUtils.addChildCDData(common, "Bill_No", info.getBillNo());
        String grdBag = info.getGrdBag();
        if (StringUtils.isEmpty((String)grdBag)) {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", "0");
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", "0");
        } else {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", info.getStartNo());
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", info.getEndNo());
        }
        JDomExtUtils.addChildCDData(common, "Enqr_StDt", LocalDateUtil.formatDate((LocalDateTime)info.getSubmitSuccessTime()));
        JDomExtUtils.addChildCDData(common, "QRY_END_DT", LocalDateUtil.formatDate((LocalDateTime)info.getSubmitSuccessTime()));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        CCBHCBankResponse rsp1 = CommonParser.getFrontResponse(rsp);
        if (!rsp1.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\uff0c%1$s %2$s\u3002\u3002", (String)"QueryPaymentImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp1.getResponseCode(), rsp1.getResponseMessage()));
        }
        rsp = rsp1.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rsp);
        if (!bankResp.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List lists = response.getChildren("Rslt_GRP");
            NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
            for (Element list : lists) {
                String TxnSrlNo = JDomUtils.getChildTextTrim((Element)list, (String)"TxnSrlNo");
                if (!TxnSrlNo.equals(info.getObssid())) continue;
                String startNo = JDomUtils.getChildTextTrim((Element)list, (String)"SbBll_Rng_Strt_SN");
                String endNo = JDomUtils.getChildTextTrim((Element)list, (String)"SbBll_Rng_End_SN");
                String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"TRN_ST_CD");
                String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_StCd");
                String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_Crcl_IndCd");
                String bankRefDate = JDomUtils.getChildTextTrim((Element)list, (String)"Pltfrm_Dt");
                String bankRefKey = JDomUtils.getChildTextTrim((Element)list, (String)"TxnSrlNo");
                info.setBankRefKey(bankRefKey);
                info.setBankRefDate(bankRefDate);
                info.setCirStatus(BkSumry);
                info.setNoteStatus(BkFlag1);
                if (BkFlag2.equals("17")) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkFlag2, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"QueryDiscountImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                    info.setStartNo(startNo);
                    info.setEndNo(endNo);
                    continue;
                }
                if (BkFlag2.equals("20") || BkFlag2.equals("21") || BkFlag2.equals("22") || BkFlag2.equals("23")) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkFlag2, (String)BkSumry);
                    continue;
                }
                if (BkFlag2.equals("24") || BkFlag2.equals("25") || BkFlag2.equals("15")) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkFlag2, (String)BkSumry);
                    continue;
                }
                if (BkFlag2.equals("02") || BkFlag2.equals("01") || BkFlag2.equals("00") || BkFlag2.equals("04") || BkFlag2.equals("10")) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkFlag2, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"QueryDiscountImpl_4", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                    continue;
                }
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkFlag2, (String)String.format(ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u72b6\u6001\u672a\u77e5%s\u3002", (String)"QueryDiscountImpl_5", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), BkSumry));
            }
        }
        return receivableInfos;
    }

    public int getBatchSize() {
        return 0;
    }
}

