/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.receivable.pledge;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.receivable.pledge.QueryPledgeImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.FileInfoNode;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.NoteFileUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class PledgeImpl
extends AbstractNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        String message;
        LoginUtils.login();
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append(PropertiesConstantsUtils.getValue((String)"ccb_pledge"));
        for (int i = 0; i < receivableInfos.length; ++i) {
            String endNo;
            String startNo;
            sBuffer.append("\r\n");
            NoteReceivableInfo info = receivableInfos[i];
            sBuffer.append(info.getBankSerialNo()).append('|');
            sBuffer.append(info.getBillNo()).append('|');
            sBuffer.append(info.getDraftAmount().toPlainString()).append('|');
            sBuffer.append(LocalDateUtil.formatDate((LocalDate)receivableInfos[i].getDueDate())).append('|');
            sBuffer.append(acnt.getAccName()).append('|');
            sBuffer.append(acnt.getAccNo()).append('|');
            sBuffer.append(acnt.getCnaps()).append('|');
            sBuffer.append(info.getDrawerBankName()).append('|');
            sBuffer.append(info.getPayeeAccName()).append('|');
            sBuffer.append(info.getPayeeAccNo()).append('|');
            sBuffer.append(info.getPayeeBankCnaps()).append('|');
            sBuffer.append(info.getPayeeBankName()).append('|');
            String grdBag = info.getGrdBag();
            if (StringUtils.isEmpty((String)grdBag)) {
                grdBag = "0";
                startNo = "0";
                endNo = "0";
            } else {
                startNo = info.getStartNo();
                endNo = info.getEndNo();
            }
            sBuffer.append(grdBag).append('|');
            sBuffer.append(info.getAmount()).append('|');
            sBuffer.append(startNo).append('|');
            sBuffer.append(endNo).append('|');
            sBuffer.append(info.getExplanation()).append('|');
            sBuffer.append("").append('|');
            sBuffer.append(info.getBankBatchSeqId()).append('|');
            sBuffer.append("");
        }
        String fileContent = sBuffer.toString();
        String datestr = DateUtil.formatDate((Date)new Date());
        String fileName = "05" + datestr + "7" + receivableInfos[0].getBankBatchSeqId() + ".txt";
        NoteFileUtils fileUtils = new NoteFileUtils();
        FileInfoNode fileInfoNode = fileUtils.getFileInfoNodes(fileContent, fileName);
        try {
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileInfoNode.getFileName());
            message = fileUtils.uploadFile(fileInfoNode);
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.logger.info(fileInfoNode.getFileContent());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"PledgeImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEN021", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomExtUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        Element file = JDomExtUtils.addChild((Element)common, (String)"FILE_LIST_PACK");
        JDomExtUtils.addChildCDData(file, "FILE_NUM", "1");
        Element fileInfo = JDomExtUtils.addChild((Element)file, (String)"FILE_INFO");
        JDomExtUtils.addChildCDData(fileInfo, "FILE_NAME", message);
        JDomExtUtils.addChildCDData(fileInfo, "Msg_Smy", fileInfoNode.getMd5());
        JDomExtUtils.addChildCDData(common, "Bl_Txn_MsgRp_Src_Tp", "100003");
        JDomExtUtils.addChildCDData(common, "Btch_Txn_Tp", "0013");
        JDomExtUtils.addChildCDData(common, "Txn_Tdnum", receivableInfos.length + "");
        JDomExtUtils.addChildCDData(common, "ExgBill_Plc_Bl_CtCd", receivableInfos[0].getDraftType());
        JDomExtUtils.addChildCDData(common, "Bl_Rmtr_Unn_Id_No", "");
        JDomExtUtils.addChildCDData(common, "Bl_Prtc_SgnSl_MtdCd", "PS01");
        JDomExtUtils.addChildCDData(common, "Bl_Prtc_Elc_Sgn", "");
        JDomExtUtils.addChildCDData(common, "MD5_Val", fileInfoNode.getMd5());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        CCBHCBankResponse rsp1 = CommonParser.getFrontResponse(rsp);
        if (!rsp1.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\uff0c%1$s %2$s\u3002", (String)"PledgeImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp1.getResponseCode(), rsp1.getResponseMessage()));
        }
        rsp = rsp1.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rsp);
        if (!bankResp.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            String BkListNo1 = response.getChildText("Btch_No");
            EBGNoteReceivableUtils.setNoteBatchNo((List)receivableInfos, (String)BkListNo1);
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)bankResp.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f%s\u3002", (String)"PledgeImpl_3", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseMessage()));
        }
        return receivableInfos;
    }
}

