/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.payable.receive;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryReceiveNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReceiveNotePayableImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1ECDS277";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u67e5\u8be2", (String)"QueryReceiveNotePayableImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List infos = request.getNotePayableInfoList();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1ECDS277", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomUtils.addChild((Element)common, (String)"BkInstNo", (String)"");
        JDomUtils.addChild((Element)common, (String)"BkListNo1", (String)((NotePayableInfo)infos.get(0)).getObssid());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List infos = request.getNotePayableInfoList();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(responseStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\uff0c%1$s %2$s\u3002", (String)"QueryReceiveNotePayableImpl_7", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        responseStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List lists = response.getChildren("Bkplmxcx_GRP");
            if (lists.size() == 0) {
                this.logger.info("\u8fd4\u56de\u7684\u8282\u70b9\u957f\u5ea6\u4e3a0");
            }
            for (int i = 0; i < infos.size(); ++i) {
                NotePayableInfo info = (NotePayableInfo)infos.get(i);
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    if (BkListNo1.equals(info.getBillNo())) {
                        String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                        String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag1");
                        String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                        this.logger.info("\u7968\u53f7\uff1a" + info.getBillNo() + "----BkFlag2:" + BkFlag2 + "----BkFlag1:" + BkFlag1);
                        if (BkFlag2.equals("00") || "030006".equals(BkFlag1)) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"QueryReceiveNotePayableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                            info.setNoteStatus("030006");
                            continue;
                        }
                        if (BkFlag2.equals("04")) {
                            info.setNoteStatus("030001");
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u5f85\u7b7e\u6536", (String)"QueryReceiveNotePayableImpl_8", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), BkSumry));
                            continue;
                        }
                        if (BkFlag2.equals("22") || BkFlag2.equals("03") || BkFlag2.equals("05") || BkFlag2.equals("09") || BkFlag2.equals("11") || BkFlag2.equals("14") || BkFlag2.equals("23")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                            info.setNoteStatus(BkFlag1);
                            continue;
                        }
                        if (BkFlag2.equals("07")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u65b9\u9a73\u56de", (String)"QueryReceiveNotePayableImpl_4", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                            continue;
                        }
                        if (BkFlag2.equals("02")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"QueryReceiveNotePayableImpl_5", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                            continue;
                        }
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u63d0\u793a\u6536\u7968\u72b6\u6001\u672a\u77e5\u3002", (String)"QueryReceiveNotePayableImpl_9", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), BkSumry));
                        continue;
                    }
                    this.logger.info("\u8fd4\u56de\u7684\u65e5\u5fd7\u4e2d\u4e0d\u5305\u542b\u5f53\u524d\u7968\u53f7");
                }
            }
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

