/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.payable.register.RegisterNotePayableImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "420105";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u67e5\u8be2", (String)"QueryRegisterNotePayableImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1ECDS254", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomUtils.addChild((Element)common, (String)"BkInstNo", (String)"");
        JDomUtils.addChild((Element)common, (String)"BkType1", (String)info.getDraftType());
        JDomUtils.addChild((Element)common, (String)"BkType2", (String)"0000");
        JDomUtils.addChild((Element)common, (String)"Bk8Date1", (String)info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)common, (String)"Bk8Date2", (String)info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)common, (String)"BkListNo2", (String)info.getContractNo());
        JDomUtils.addChild((Element)common, (String)"BkAcctNum", (String)"1");
        Element BkAcctQuery_GRP = JDomUtils.addChild((Element)common, (String)"BkAcctNum");
        JDomUtils.addChild((Element)BkAcctQuery_GRP, (String)"BkEcdQueryAcct", (String)info.getDrawerAccNo());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfoList = request.getNotePayableInfoList();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(responseStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"QueryRegisterNotePayableImpl_6", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        responseStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfoList, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List list = response.getChildren("Bkplmxcx_GRP");
            if (list.size() == 0) {
                this.logger.info("\u8fd4\u56de\u7684\u8282\u70b9\u957f\u5ea6\u4e3a0");
            }
            for (int i = 0; i < notePayableInfoList.size(); ++i) {
                NotePayableInfo info = (NotePayableInfo)notePayableInfoList.get(i);
                for (Element element : list) {
                    String BkListNo1 = element.getChildTextTrim("BkListNo1");
                    String BkListNo5 = element.getChildTextTrim("BkListNo5");
                    String status = element.getChildTextTrim("BkFlag2");
                    String BkDetail3 = element.getChildTextTrim("BkDetail3");
                    String BkFlag1 = element.getChildTextTrim("BkFlag1");
                    this.logger.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u51fa\u7968\u4eba\u53f7\u7801\uff1a" + BkListNo5 + "\u539f\u7968\u53f7\uff1a" + info.getBillNo() + "\u7535\u5b50\u7968\u636e\u53f7\u7801" + BkListNo1);
                    if (info.getBillNo().equals(BkListNo5) || info.getBillNo().equals(BkListNo1)) {
                        this.logger.info("\u5339\u914d\u5230\u7968\u53f7" + info.getBillNo());
                        if ("AC01".equals(info.getDraftType())) {
                            if ("020006".equals(BkFlag1)) {
                                info.setBillNo(BkListNo1);
                                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u6210\u529f", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                                info.setNoteStatus(BkFlag1);
                                continue;
                            }
                            if (!"020001".equals(BkFlag1)) continue;
                            info.setBillNo(BkListNo1);
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u6210\u529f", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                            info.setNoteStatus(BkFlag1);
                            continue;
                        }
                        if ("010004".equals(BkFlag1)) {
                            info.setBillNo(BkListNo1);
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u6210\u529f", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                            info.setNoteStatus(BkFlag1);
                            continue;
                        }
                        info.setBillNo(BkListNo1);
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u6210\u529f", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                        info.setNoteStatus(BkFlag1);
                        continue;
                    }
                    if (status.equals("22") || status.equals("03") || status.equals("05") || status.equals("09") || status.equals("11") || status.equals("14") || status.equals("23")) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u5931\u8d25\u3002", (String)"QueryRegisterNotePayableImpl_3", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                        continue;
                    }
                    if (status.equals("02")) {
                        info.setNoteStatus(BkFlag1);
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"QueryRegisterNotePayableImpl_4", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5", (String)"QueryRegisterNotePayableImpl_5", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                }
            }
        }
        return notePayableInfoList;
    }

    public int getBatchSize() {
        return 0;
    }
}

