/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.accept;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Packer;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryAcceptNotePayableImpl
extends AbstractQueryNotePayableImpl {
    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e003040";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u67e5\u8be2", (String)"QueryAcceptNotePayableImpl_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        CEBHelper.configFactory(factory, "b2e003040");
        super.configFactory(factory);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List infos = request.getNotePayableInfoList();
        Element root = Packer.createNoteHead("b2e003040");
        Element reqData = root.getChild("TransContent").getChild("ReqData");
        JDomUtils.addChild((Element)reqData, (String)"AcNo", (String)((NotePayableInfo)infos.get(0)).getDrawerAccNo());
        JDomUtils.addChild((Element)reqData, (String)"BillType", (String)((NotePayableInfo)infos.get(0)).getDraftType());
        JDomUtils.addChild((Element)reqData, (String)"CDStatus", (String)"2");
        JDomUtils.addChild((Element)reqData, (String)"StartDate", (String)DateUtil.formatDate((LocalDate)((NotePayableInfo)infos.get(0)).getSubmitSuccessTime().toLocalDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqData, (String)"EndDate", (String)DateUtil.formatDate((LocalDate)((NotePayableInfo)infos.get(0)).getSubmitSuccessTime().toLocalDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqData, (String)"StartNum", (String)"1");
        JDomUtils.addChild((Element)reqData, (String)"QueryNum", (String)"50");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List infos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)infos.get(0);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        if (!"0000".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return infos;
        }
        Namespace ns = root.getNamespace();
        List respDatas = root.getChild("TransContent", ns).getChild("BatchRespList", ns).getChildren("RespData", ns);
        Element rs = (Element)respDatas.get(0);
        if (!((NotePayableInfo)infos.get(0)).getObssid().equals(rs.getChildText("BillId", ns))) {
            return infos;
        }
        String rsBillNo = rs.getChildText("BillNo", ns);
        String BILLSTATUS = rs.getChildText("BillStatus", ns);
        info.setBillNo(rsBillNo);
        String[] status = CEBHelper.CEBBILLSTATUS.get(BILLSTATUS);
        String[] success = new String[]{"B_02"};
        String[] fail = new String[]{"D_07"};
        if (status != null) {
            PaymentState state = CEBHelper.getNoteState(success, fail, BILLSTATUS);
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)state, (String)BILLSTATUS, (String)status[0], (String)"");
            info.setNoteStatus(status[1]);
        } else {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryAcceptNotePayableImpl_1", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

