/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.receive;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryNoteParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNoteParser.class);

    public void parseQueryPay(NotePayableInfo[] notePayableInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        Namespace ns = root.getNamespace();
        if (!"0000".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        List respDatas = root.getChild("TransContent", ns).getChild("BatchRespList", ns).getChildren("RespData", ns);
        Element rs = null;
        String rsBillNo = "";
        for (Element data : respDatas) {
            if (!data.getChildText("BillNo", ns).equals(notePayableInfos[0].getBillNo())) continue;
            rs = data;
            rsBillNo = data.getChildText("BillNo", ns);
            this.logger.info("\u5339\u914d\u6210\u529f");
            break;
        }
        if (StringUtils.isEmpty((String)rsBillNo)) {
            this.logger.info("\u5339\u914d\u5931\u8d25");
            return;
        }
        this.logger.info("\u5339\u914d\u5230\u7684\u7968\u636e\u53f7:" + rsBillNo);
        if (rs != null) {
            String BILLSTATUS = rs.getChildText("BillStatus", ns);
            notePayableInfos[0].setBillNo(rsBillNo);
            this.logger.info("BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo);
            if ("1".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u4ea4\u4ed8\u672a\u7b7e\u6536", (String)"QueryNoteParser_3", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
                notePayableInfos[0].setNoteStatus("030001");
            } else if ("3".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u4ea4\u4ed8\u5df2\u7b7e\u6536", (String)"QueryNoteParser_4", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
                notePayableInfos[0].setNoteStatus("030006");
            } else if ("2".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.FAIL, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u4ea4\u4ed8\u5df2\u62d2\u7edd", (String)"QueryNoteParser_5", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
            } else {
                EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.UNKNOWN, (String)BILLSTATUS, (String)"");
            }
        }
    }
}

