/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.register.addbill;

import java.time.LocalDate;
import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.Packer;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class NotePacker {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NotePacker.class);

    public String packPay(List<NotePayableInfo> notePayableInfos) throws EBServiceException {
        this.logger.info("*****2\u3001\u65b0\u589e\u7968\u636e\u660e\u7ec6\u4fe1\u606f***");
        NotePayableInfo info = notePayableInfos.get(0);
        Element root = Packer.createNoteHead("b2e003008");
        Element reqData = root.getChild("TransContent").getChild("ReqData");
        JDomUtils.addChild((Element)reqData, (String)"BatchNo", (String)info.getRqstserialno());
        JDomUtils.addChild((Element)reqData, (String)"AcNo", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)reqData, (String)"Amount", (String)info.getAmount().toPlainString());
        JDomUtils.addChild((Element)reqData, (String)"AcptDate", (String)DateUtil.formatDate((LocalDate)info.getBookingDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqData, (String)"DueDate", (String)DateUtil.formatDate((LocalDate)info.getDueDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqData, (String)"AcName2", (String)info.getPayeeAccName());
        boolean isSameBank = false;
        if (SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        JDomUtils.addChild((Element)reqData, (String)"BankType", (String)(isSameBank ? "0" : "1"));
        if (!isSameBank) {
            JDomUtils.addChild((Element)reqData, (String)"PayeeBankName", (String)info.getPayeeBankName());
            JDomUtils.addChild((Element)reqData, (String)"PayeeBankNo", (String)info.getPayeeBankCnaps());
        }
        JDomUtils.addChild((Element)reqData, (String)"AcNo2", (String)info.getPayeeAccNo());
        JDomUtils.addChild((Element)reqData, (String)"ConfernNo", (String)info.getContractNo());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }
}

