/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.revocation;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryNoteParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNoteParser.class);

    public void parseQueryPay(NotePayableInfo[] notePayableInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        Namespace ns = root.getNamespace();
        if (!"0000".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        List respDatas = root.getChild("TransContent", ns).getChild("BatchRespList", ns).getChildren("RespData", ns);
        Element rs = null;
        String rsBillNo = "";
        for (Element data : respDatas) {
            if (!data.getChildText("BillNo", ns).equals(notePayableInfos[0].getBillNo())) continue;
            rs = data;
            rsBillNo = data.getChildText("BillNo", ns);
            this.logger.info("\u5339\u914d\u6210\u529f");
            break;
        }
        if (StringUtils.isEmpty((String)rsBillNo)) {
            this.logger.info("\u5339\u914d\u5931\u8d25");
            EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e0d\u5305\u542b\u8be5\u7968\u636e\uff0c\u65e0\u6cd5\u89e3\u6790\u4ea4\u6613\u72b6\u6001\u3002", (String)"QueryNoteParser_7", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
            return;
        }
        this.logger.info("\u5339\u914d\u5230\u7684\u7968\u636e\u53f7:" + rsBillNo);
        String BILLSTATUS = "";
        if (rs != null) {
            BILLSTATUS = rs.getChildText("BillStatus", ns);
        }
        String status = CEBHelper.BILLSTATUS.get(BILLSTATUS);
        String[] statusArray = CEBHelper.CEBBILLSTATUS.get(status);
        this.logger.info("\u5339\u914d\u5230\u7684\u7968\u636e\u53f7:" + rsBillNo + ",\u94f6\u884c\u8fd4\u56de\u7684\u72b6\u6001\uff1a" + BILLSTATUS + ",\u5339\u914d\u5230\u7684\u72b6\u6001\u7801\uff1a" + status);
        String[] success = new String[]{"D_07"};
        String[] fail = new String[]{""};
        if (status != null) {
            PaymentState state = CEBHelper.getNoteState(success, fail, BILLSTATUS);
            EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)state, (String)"", (String)BILLSTATUS);
            notePayableInfos[0].setNoteStatus(statusArray[1]);
        } else {
            EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)BILLSTATUS);
        }
    }
}

