/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.receivable.cancel;

import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.business.notePayable.util.QueryNotePayableUtil;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryParser {
    public void parseQueryPay(NoteReceivableInfo[] receivableInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        Namespace ns = root.getNamespace();
        if (!"0000".equals(response.getResponseCode())) {
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Element respData = root.getChild("TransContent", ns).getChild("RespData", ns);
        String billStatus = respData.getChildText("BillStatus", ns);
        String[] status = CEBHelper.CEBBILLSTATUS.get(billStatus);
        if (status == null) {
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)PaymentState.UNKNOWN, (String)billStatus, (String)"");
        } else {
            String operationCode = receivableInfos[0].getOperationCode();
            if ("02".equals(operationCode) && "A_01".equals(billStatus)) {
                this.setNoteBusinessStatus(receivableInfos[0], PaymentState.SUCCESS, billStatus, ResManager.loadKDString((String)"\u627f\u5151\u64a4\u9500\u6210\u529f", (String)"QueryParser_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
            } else if ("03".equals(operationCode) && "B_02".equals(billStatus)) {
                this.setNoteBusinessStatus(receivableInfos[0], PaymentState.SUCCESS, billStatus, ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u64a4\u9500\u6210\u529f", (String)"QueryParser_1", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
            } else {
                this.setNoteBusinessStatus(receivableInfos[0], PaymentState.UNKNOWN, billStatus, String.format(ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5\uff1a%s\u3002", (String)"QueryParser_6", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]), response.getResponseMessage()));
            }
            if (status.length > 1) {
                receivableInfos[0].setNoteStatus(status[1]);
            }
        }
    }

    private void setNoteBusinessStatus(NoteReceivableInfo info, PaymentState state, String bankStatus, String bankMsg) {
        info.setStatus(Integer.valueOf(state.getId()));
        info.setBankStatus(bankStatus);
        info.setBankMsg(bankMsg);
    }
}

