/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.receivable.discount;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.banks.ceb.dc.service.receivable.discount.commit.NoteImpl;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryParser.class);

    public List<NoteReceivableInfo> parseQueryPay(List<NoteReceivableInfo> receivableInfos, String rsp) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        Namespace ns = root.getNamespace();
        if (!"0000".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return receivableInfos;
        }
        List respDatas = root.getChild("TransContent", ns).getChild("BatchRespList", ns).getChildren("RespData", ns);
        Element rs = null;
        String rsBillNo = "";
        for (Element data : respDatas) {
            if (!data.getChildText("BillNo", ns).equals(receivableInfos.get(0).getBillNo())) continue;
            rs = data;
            rsBillNo = data.getChildText("BillNo", ns);
            this.logger.info("\u5339\u914d\u6210\u529f");
            break;
        }
        if (StringUtils.isEmpty((String)rsBillNo)) {
            this.logger.info("\u5339\u914d\u5931\u8d25");
            return receivableInfos;
        }
        this.logger.info("\u5339\u914d\u5230\u7684\u7968\u636e\u53f7:" + rsBillNo);
        if (StringUtils.isNotEmpty((String)rsBillNo) && !"discounting".equals(receivableInfos.get(0).getReserved1())) {
            receivableInfos.get(0).setReserved1("discount");
        }
        if ("discount".equals(receivableInfos.get(0).getReserved1())) {
            new NoteImpl().doBiz(receivableInfos);
        } else {
            String billStatus = "";
            if (rs != null) {
                billStatus = rs.getChildText("BillStatus", ns);
            }
            if (ResManager.loadKDString((String)"\u5df2\u53d7\u7406", (String)"QueryParser_3", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]).equals(billStatus)) {
                EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)billStatus);
                receivableInfos.get(0).setNoteStatus("110106");
            } else if (ResManager.loadKDString((String)"\u62d2\u7edd\u7b7e\u6536", (String)"QueryParser_4", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]).equals(billStatus)) {
                EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)billStatus);
            } else if (ResManager.loadKDString((String)"\u672a\u53d7\u7406", (String)"QueryParser_5", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]).equals(billStatus)) {
                EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)billStatus);
                receivableInfos.get(0).setNoteStatus("110101");
            } else {
                EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)billStatus);
            }
        }
        return receivableInfos;
    }
}

