/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.payable.register;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.QueryUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P70101";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        NotePayableInfo[] infos = bankNotePayableRequest.getNotePayableInfosAsArray();
        JSONObject root = new JSONObject();
        JSONObject requestDto = new JSONObject();
        requestDto.put("applAcctNo", (Object)infos[0].getDrawerAccNo());
        requestDto.put("operCode", (Object)"OC00");
        requestDto.put("dataSource", (Object)"1");
        requestDto.put("batchNumber", (Object)infos[0].getBankBatchSeqId());
        root.put("requestDto", (Object)requestDto);
        JSONArray reqInfoList = new JSONArray();
        requestDto.put("reqInfoList", (Object)reqInfoList);
        for (int i = 0; i < infos.length; ++i) {
            NotePayableInfo info = infos[i];
            JSONObject object = new JSONObject();
            reqInfoList.add((Object)object);
            if (info.getDraftType().equals("AC02")) {
                object.put("ifAssuFlag", (Object)"0");
            }
            object.put("pyeeAcctNo", (Object)info.getPayeeAccNo());
            object.put("acptName", (Object)info.getAcceptorAccName());
            object.put("billMoney", (Object)info.getAmount());
            object.put("dueDt", (Object)LocalDateUtil.formatDate((LocalDate)info.getDueDate()));
            object.put("acptAcctNo", (Object)info.getAcceptorAccNo());
            object.put("drwrAcctNo", (Object)info.getDrawerAccNo());
            object.put("billOrigin", (Object)"CS02");
            object.put("drwrBankNo", (Object)info.getDrawerBankCnaps());
            object.put("drwrName", (Object)info.getDrawerAccName());
            object.put("remitDt", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            object.put("billType", (Object)info.getDraftType());
            object.put("banEndrsmtMark", (Object)"EM00");
            object.put("acptBankNo", (Object)info.getAcceptorBankCnaps());
            object.put("billClass", (Object)"ME02");
            object.put("pyeeName", (Object)info.getPayeeAccName());
            object.put("pyeeBankNo", (Object)info.getPayeeBankCnaps());
            object.put("isAllowSplitBill", (Object)info.getGrdBag());
            object.put("txlFlowNo", (Object)info.getBankDetailSeqId());
            object.put("phone", (Object)"");
        }
        return PackerUtil.getPackerResult(root.toJSONString(), "P70101");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List infos = bankNotePayableRequest.getNotePayableInfoList();
        JSONObject retData = ParserUtil.getJsonRoot(rspStr);
        String retCode = retData.getString("retCode");
        if (!"000000".equals(retCode)) {
            String retMsg = retData.getString("retMsg");
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)retCode, (String)retMsg);
        } else {
            JSONObject content = retData.getJSONObject("retData");
            JSONArray list = content.getJSONArray("list");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject object = (JSONObject)list.get(i);
                String txlFlowNo = object.getString("txlFlowNo");
                NotePayableInfo info = QueryUtil.selectPayable(infos, txlFlowNo);
                if (info == null) continue;
                String billId = object.getString("billId");
                String hldrId = object.getString("hldrId");
                if (StringUtils.isEmpty((String)billId) || StringUtils.isEmpty((String)hldrId)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)retCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4e0d\u5168\uff0c\u65e0\u6cd5\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\uff0c\u8bf7\u7ebf\u4e0b\u786e\u8ba4\u3002", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    return infos;
                }
                info.setReserved1(billId);
                info.setReserved2(hldrId);
                info.setBankRefKey(billId + "_" + hldrId);
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u51fa\u7968\u63d0\u4ea4\u94f6\u4f01\u6210\u529f\u3002", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                try {
                    String confirm = this.confirm(info);
                    String res = this.doBussiness(confirm);
                    this.confirm(info, res);
                    continue;
                }
                catch (Exception e) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)retCode, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u5f02\u5e38", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u5f02\u5e38", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
        return infos;
    }

    public String confirm(NotePayableInfo info) {
        JSONObject root = new JSONObject();
        JSONObject requestDto = new JSONObject();
        requestDto.put("dataSource", (Object)"1");
        if (info.getAutoAccept().equals("1") && info.getAutoReceive().equals("1")) {
            requestDto.put("drwrAutoType", (Object)"AT04");
        } else if (info.getAutoAccept().equals("1")) {
            requestDto.put("drwrAutoType", (Object)"AT02");
        } else {
            requestDto.put("drwrAutoType", (Object)"AT00");
        }
        requestDto.put("operCode", (Object)"OC00");
        requestDto.put("batchNumber", (Object)Sequence.gen16NumSequence());
        root.put("requestDto", (Object)requestDto);
        JSONArray reqInfoList = new JSONArray();
        requestDto.put("reqInfoList", (Object)reqInfoList);
        JSONObject object = new JSONObject();
        reqInfoList.add((Object)object);
        object.put("applAcctNo", (Object)info.getDrawerAccNo());
        object.put("applBankNo", (Object)info.getDrawerBankCnaps());
        object.put("billId", (Object)info.getReserved1());
        object.put("hldrId", (Object)info.getReserved2());
        object.put("transAmt", (Object)info.getAmount().toString());
        object.put("transNo", (Object)"NES.001.20.00P");
        if (info.getAutoAccept().equals("1") && info.getAutoReceive().equals("1")) {
            object.put("drwrAutoType", (Object)"AT04");
        } else if (info.getAutoAccept().equals("1")) {
            object.put("drwrAutoType", (Object)"AT02");
        } else {
            object.put("drwrAutoType", (Object)"AT00");
        }
        object.put("reserveFlag", (Object)"0");
        return PackerUtil.getPackerResult(root.toJSONString(), "P70104");
    }

    public void confirm(NotePayableInfo info, String rspStr) {
        JSONObject retData = ParserUtil.getJsonRoot(rspStr);
        String retCode = retData.getString("retCode");
        String retMsg = retData.getString("retMsg");
        if (!"000000".equals(retCode)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)retCode, (String)retMsg);
        } else {
            JSONObject content = retData.getJSONObject("retData");
            JSONArray list = content.getJSONArray("list");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject object = (JSONObject)list.get(i);
                String billId = object.getString("billId");
                String hldrId = object.getString("hldrId");
                if (StringUtils.isEmpty((String)billId) || StringUtils.isEmpty((String)hldrId)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)retCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4e0d\u5168\uff0c\u65e0\u6cd5\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\uff0c\u8bf7\u7ebf\u4e0b\u786e\u8ba4\u3002", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                }
                info.setReserved1("");
                info.setReserved2(hldrId);
                String transId = object.getString("transId");
                String msgId = object.getString("msgId");
                info.setBankRefKey(transId + "_" + msgId);
                info.setReserved3(transId);
                info.setReversed4("");
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u51fa\u7968\u63d0\u4ea4\u94f6\u4f01\u6210\u529f\u3002", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
            }
        }
    }
}

