/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.receivable.cancle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.receivable.cancle.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70106";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u7533\u8bf7\u64a4\u56de(P70106)", (String)"CancleNoteReceivableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo[] receivableInfos = request.getNotePayableInfosAsArray();
        JSONObject root = new JSONObject();
        JSONObject requestDto = new JSONObject();
        requestDto.put("dataSource", (Object)"1");
        root.put("requestDto", (Object)requestDto);
        JSONArray reqInfoList = new JSONArray();
        requestDto.put("reqInfoList", (Object)reqInfoList);
        for (int i = 0; i < receivableInfos.length; ++i) {
            NoteReceivableInfo info = receivableInfos[i];
            JSONObject object = new JSONObject();
            reqInfoList.add((Object)object);
            object.put("applAcctNo", (Object)info.getDrawerAccNo());
            String billId_hldrId = info.getBankRefKey();
            if (StringUtils.isEmpty((String)billId_hldrId)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406\u3002", (String)"CancleNoteReceivableImpl_3", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
            }
            String[] bankRefKey = billId_hldrId.split("_");
            if (bankRefKey.length < 4) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u64a4\u9500bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406", (String)"CancleNoteReceivableImpl_4", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
            }
            object.put("transId", (Object)bankRefKey[2]);
            object.put("msgId", (Object)bankRefKey[3]);
            object.put("reserveFlag", (Object)"0");
            object.put("rmrkByPropsr", (Object)info.getExplanation());
        }
        return PackerUtil.getPackerResult(root.toJSONString(), "P70106");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String rspStr) {
        List infos = request.getNoteReceivableInfos();
        ParserUtil.parsePay(infos, rspStr);
        return infos;
    }
}

