/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.detail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.detail.endorseInfo.EndorseInfoImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Parser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NoteDetailPacker;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import kd.ebg.note.common.framework.utils.ParserUtils;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"1.1..87 \u7968\u636e\u67e5\u8be2-\u67e5\u8be2\u591a\u7b14\u7968\u636e\u6982\u8981\u4fe1\u606f\uff08421101\uff09", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6682\u4e0d\u652f\u6301\u6301\u7968\u67e5\u8be2", (String)"NoteDetailImpl_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        BankNoteDetailRequestBody requestBody = request.getBody();
        BankAcnt acnt = request.getAcnt();
        String tranType = requestBody.getTranType();
        String transCode = "";
        String opType = "";
        if (tranType.equals("03")) {
            transCode = "QBPCOLS";
            opType = "11";
        } else if (tranType.equals("02")) {
            transCode = "QBACPTL";
            opType = "30";
        } else if (tranType.equals("10")) {
            transCode = "QBENDOS";
            opType = "12";
        } else if (tranType.equals("20")) {
            transCode = "QBPPAYS";
            opType = "14";
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5904\u7406\u7684\u56de\u590d\u7c7b\u578b\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        return new NoteDetailPacker().packNoteDetailReplyRequset(request, pageTag, acnt, transCode, opType);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        String encoding;
        BankAcnt acnt = request.getAcnt();
        BankNoteDetailRequestBody requestbody = request.getBody();
        String tranType = requestbody.getTranType();
        ArrayList<Detail> detailList = new ArrayList<Detail>(1);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)(encoding = RequestContextUtils.getCharset()));
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element pub = JDomUtils.getChildElement((Element)eb, (String)"pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        if (headRsp.getResponseCode().equals("B0116")) {
            return detailList;
        }
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equals(headRsp.getResponseCode()) && !"B0116".equals(headRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"NoteDetailImpl_6", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), bankStatus + headRsp.getResponseMessage()));
        }
        Element out = JDomUtils.getChildElement((Element)eb, (String)"out");
        List rds = out.getChildren("rd");
        for (Element rd : rds) {
            Detail detailInfo = new Detail();
            detailInfo.setIssueDate(JDomUtils.getChildText((Element)rd, (String)"BillOpenDate"));
            detailInfo.setDueDate(JDomUtils.getChildText((Element)rd, (String)"BillDueDate"));
            detailInfo.setNoteNo(JDomUtils.getChildText((Element)rd, (String)"BillNo"));
            detailInfo.setDraftType(JDomUtils.getChildText((Element)rd, (String)"BillType"));
            detailInfo.setAcceptorAccName(JDomUtils.getChildText((Element)rd, (String)"AcceptName"));
            detailInfo.setAcceptorBankName(JDomUtils.getChildText((Element)rd, (String)"AcceptBank"));
            detailInfo.setAcceptorCnapsCode(JDomUtils.getChildText((Element)rd, (String)"AcceptBankNo"));
            detailInfo.setAcceptorAccNo(JDomUtils.getChildText((Element)rd, (String)"AcceptAccNo"));
            detailInfo.setDrawerAccName(JDomUtils.getChildText((Element)rd, (String)"BillOpenName"));
            detailInfo.setDrawerAccNo(JDomUtils.getChildText((Element)rd, (String)"BillOpenAcc"));
            detailInfo.setDrawerBankName(JDomUtils.getChildText((Element)rd, (String)"BillOpenBank"));
            detailInfo.setPayeeAccName(JDomUtils.getChildText((Element)rd, (String)"RecvAccName"));
            detailInfo.setPayeeAccNo(JDomUtils.getChildText((Element)rd, (String)"RecvAccNo"));
            detailInfo.setPayeeBankName(JDomUtils.getChildText((Element)rd, (String)"RecvBankName"));
            detailInfo.setApplicantAcNo(JDomUtils.getChildText((Element)rd, (String)"BillHoldAcc"));
            detailInfo.setApplicantAcName(JDomUtils.getChildText((Element)rd, (String)"BillHoldName"));
            detailInfo.setApplicantBankName(JDomUtils.getChildText((Element)rd, (String)"BillHoldBank"));
            detailInfo.setHolderAccNo(JDomUtils.getChildText((Element)rd, (String)"BillHoldAcc"));
            detailInfo.setPreHolderName(JDomUtils.getChildText((Element)rd, (String)"BillHoldName"));
            detailInfo.setTransferFlag(JDomUtils.getChildText((Element)rd, (String)"ReciteFlag"));
            String billAmt = JDomUtils.getChildText((Element)rd, (String)"BillAmt");
            String billStat = JDomUtils.getChildText((Element)rd, (String)"BillStat");
            EndorseInfoImpl impl = new EndorseInfoImpl();
            String billNo = JDomUtils.getChildText((Element)rd, (String)"BillNo");
            detailInfo.setNoteStatus(billStat);
            this.logger.info("\u83b7\u53d6\u5230\u7684\u7535\u7968\u72b6\u6001\uff1a" + billStat);
            String Remark = JDomUtils.getChildText((Element)rd, (String)"Remark");
            String RefNo = JDomUtils.getChildText((Element)rd, (String)"RefNo");
            String BankTranSerial = JDomUtils.getChildText((Element)rd, (String)"BankTranSerial");
            detailInfo.setBankRefKey(BankTranSerial);
            this.logger.info("\u83b7\u53d6\u5230\u7684\u94f6\u884c\u6d41\u6c34\u53f7\uff1a" + BankTranSerial);
            detailInfo.setExplain(Remark);
            detailInfo.setRemark(Remark);
            detailInfo.setBusinessCode(tranType);
            if (!requestbody.getTranType().equals("03") && !requestbody.getTranType().equals("02")) {
                try {
                    List<NoteSidesInfo> list = impl.getMessage(billNo);
                    Collections.reverse(list);
                    for (int i = 0; i < list.size(); ++i) {
                        list.get(i).setResv1(i + "");
                    }
                    detailInfo.setNoteSidesInfo(list);
                }
                catch (Exception e) {
                    detailInfo.setIsNoteSidesError("Y");
                }
            }
            if (StringUtils.isEmpty((String)billAmt)) {
                detailInfo.setAmount("0");
            } else {
                detailInfo.setAmount(String.valueOf(ParserUtils.convertCentStr2Yuan((String)billAmt)));
            }
            detailInfo.setBankRefKey(JDomUtils.getChildText((Element)rd, (String)"RefNo"));
            this.logger.info("amount:" + detailInfo.getAmount());
            detailList.add(detailInfo);
        }
        return detailList;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, false);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element pub = JDomUtils.getChildElement((Element)eb, (String)"pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equals(headRsp.getResponseCode()) && !"B0116".equals(headRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ee3\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u5206\u9875\u5f02\u5e38\uff1a%s\u3002", (String)"NoteDetailImpl_7", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), bankStatus));
        }
        Element out = JDomUtils.getChildElement((Element)eb, (String)"out");
        String NextTag = JDomUtils.getChildText((Element)out, (String)"NextTag");
        return NextTag;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        return StringUtils.isEmpty((String)pageTag);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        if ("0".equals(request.getBody().getIsNewECDS())) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.detail.NoteDetailImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.detail.NoteDetailImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

