/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.payable.accept;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.payable.accept.QueryAcceptNotePayableImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Parser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class AcceptNotePayableImpl
extends AbstractNotePayableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(AcceptNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryAcceptNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QBIINFO";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151", (String)"AcceptNotePayableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        NotePayableInfo[] notePayableInfos = request.getNotePayableInfosAsArray();
        NotePayableInfo notePayableInfo = notePayableInfos[0];
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("QBIINFO");
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)notePayableInfo.getBillNo());
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(reqstMsg, "QBIINFO");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element pub = JDomUtils.getChildElement((Element)eb, (String)"pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equals(headRsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u627f\u5151\u7ed3\u679c\u5931\u8d25", (String)"AcceptNotePayableImpl_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), (String)headRsp.getResponseMessage());
            return notePayableInfos;
        }
        Element out = JDomUtils.getChildElement((Element)eb, (String)"out");
        String BillState = JDomUtils.getChildText((Element)out, (String)"BillState");
        info.setNoteStatus(BillState);
        if ("020001".equals(BillState)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"020001", (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"AcceptNotePayableImpl_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if ("020006".equals(BillState)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"020006", (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u6210\u529f", (String)"AcceptNotePayableImpl_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"AcceptNotePayableImpl_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        return notePayableInfos;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public EBBankNotePayableResponse doBizNoPage(BankNotePayableRequest request) {
        try {
            String requestStr = this.pack(request, null);
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection connection = this.getConnection(factory);
            this.openConnection(connection);
            try {
                Throwable throwable = null;
                try (OutputStream outputStream = this.getOutputStream(connection);){
                    EBBankNotePayableResponse eBBankNotePayableResponse;
                    Throwable throwable2;
                    InputStream inputStream;
                    block36: {
                        block37: {
                            this.send(outputStream, requestStr);
                            inputStream = this.getInputStream(connection);
                            throwable2 = null;
                            String responseStr = this.recv(inputStream);
                            eBBankNotePayableResponse = new EBBankNotePayableResponse(this.parse(request, responseStr));
                            if (inputStream == null) break block36;
                            if (throwable2 == null) break block37;
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block36;
                        }
                        inputStream.close();
                    }
                    return eBBankNotePayableResponse;
                    catch (Throwable throwable4) {
                        try {
                            try {
                                try {
                                    throwable2 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (inputStream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (Throwable throwable6) {
                                                throwable2.addSuppressed(throwable6);
                                            }
                                        } else {
                                            inputStream.close();
                                        }
                                    }
                                    throw throwable5;
                                }
                            }
                            catch (Throwable t) {
                                logger.error("\u53d1\u9001\u5f02\u5e38\uff1a" + t.getMessage());
                                EBContext.getContext().setThrowableAfterSend(t);
                                throwable2 = null;
                                if (outputStream != null) {
                                    if (throwable != null) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        outputStream.close();
                                    }
                                }
                                return throwable2;
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        catch (Throwable throwable9) {
                            throw throwable9;
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.error("\u53d1\u9001\u5f02\u5e38\uff1a" + t.getMessage());
                EBContext.getContext().setThrowableAfterSend(t);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage());
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return null;
        }
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        NotePayableInfo notePayableInfo = (NotePayableInfo)request.getNotePayableInfoList().get(0);
        if (notePayableInfo.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.payable.accept.AcceptNotePayableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.payable.accept.AcceptNotePayableImpl();
            return impl.doBiz(request);
        }
        return this.doBizNoPage(request);
    }
}

