/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0101";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968(b2e0101)", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNotePayableRequest request, String pageTag) {
        LoginAccess la = LoginAccessManager.searchLock();
        List infos = request.getNotePayableInfoList();
        try {
            String requestStr;
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0101");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0101-rq");
            if (infos.size() > 50) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u51fa\u7968\u4e0d\u80fd\u8d85\u8fc750\u7b14\u3002", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            for (int i = 0; i < infos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0101-rq");
                JDomUtils.addChild((Element)rq, (String)"insid", (String)((NotePayableInfo)infos.get(i)).getDetailSeqId());
                JDomUtils.addChild((Element)rq, (String)"drafttype", (String)((NotePayableInfo)infos.get(i)).getDraftType());
                Element drawee = JDomUtils.addChild((Element)rq, (String)"drawee");
                JDomUtils.addChild((Element)drawee, (String)"ibknum", (String)"");
                JDomUtils.addChild((Element)drawee, (String)"actacn", (String)((NotePayableInfo)infos.get(i)).getDrawerAccNo());
                JDomUtils.addChild((Element)drawee, (String)"actnam", (String)((NotePayableInfo)infos.get(i)).getDrawerAccName());
                Element toactn = JDomUtils.addChild((Element)rq, (String)"toactn");
                JDomUtils.addChild((Element)toactn, (String)"ibknum", (String)((NotePayableInfo)infos.get(i)).getPayeeBankCnaps());
                JDomUtils.addChild((Element)toactn, (String)"actacn", (String)((NotePayableInfo)infos.get(i)).getPayeeAccNo());
                JDomUtils.addChild((Element)toactn, (String)"actnam", (String)((NotePayableInfo)infos.get(i)).getPayeeAccName());
                Element acceptor = JDomUtils.addChild((Element)rq, (String)"acceptor");
                JDomUtils.addChild((Element)acceptor, (String)"ibknum", (String)((NotePayableInfo)infos.get(i)).getAcceptorBankCnaps());
                JDomUtils.addChild((Element)acceptor, (String)"actacn", (String)((NotePayableInfo)infos.get(i)).getAcceptorAccNo());
                JDomUtils.addChild((Element)acceptor, (String)"actnam", (String)((NotePayableInfo)infos.get(i)).getAcceptorAccName());
                JDomUtils.addChild((Element)rq, (String)"bookdate", (String)((NotePayableInfo)infos.get(i)).getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rq, (String)"duedate", (String)((NotePayableInfo)infos.get(i)).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rq, (String)"amount", (String)((NotePayableInfo)infos.get(i)).getAmount().toString());
                JDomUtils.addChild((Element)rq, (String)"transferflg", (String)((NotePayableInfo)infos.get(i)).getTransferFlag());
                String sequence = Sequence.genSequence();
                JDomUtils.addChild((Element)rq, (String)"memo", (String)((NotePayableInfo)infos.get(i)).getExplanation());
                ((NotePayableInfo)infos.get(i)).setSequence(sequence);
                JDomUtils.addChild((Element)rq, (String)"autoacp", (String)((NotePayableInfo)infos.get(i)).getAutoAccept());
                JDomUtils.addChild((Element)rq, (String)"autorec", (String)((NotePayableInfo)infos.get(i)).getAutoReceive());
            }
            String string = requestStr = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0101-rs");
        if (trn == null) {
            Element b2eerror = trans.getChild("trn-b2eerror-rs");
            Element status = b2eerror.getChild("status");
            String rspcod = status.getChildTextTrim("rspcod");
            String rspmsg = status.getChildTextTrim("rspmsg");
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)rspcod, (String)rspmsg);
            return notePayableInfos;
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0101-rs");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                String insid = rs.getChildTextTrim("insid");
                Element another_status = rs.getChild("status");
                String another_rspcod = another_status.getChildTextTrim("rspcod");
                String another_rspmsg = another_status.getChildTextTrim("rspmsg");
                String obssid = rs.getChildText("obssid");
                for (NotePayableInfo notePayableInfo : notePayableInfos) {
                    if (!insid.equals(notePayableInfo.getDetailSeqId()) && !insid.equals("12345678910")) continue;
                    notePayableInfo.setObssid(obssid);
                    notePayableInfo.setRspserialno(obssid);
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                    } else {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                    }
                    notePayableInfo.setQueryType("register");
                }
            }
        }
        return notePayableInfos;
    }
}

