/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.note.detail;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.note.detail.endorseInfo.EndorseInfoImpl;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_NotePacker;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_Parser;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"1.1..87 \u7968\u636e\u67e5\u8be2-\u67e5\u8be2\u591a\u7b14\u7968\u636e\u6982\u8981\u4fe1\u606f\uff08421101\uff09", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return !noteDetailRequest.getBody().getIsNewECDS().equals("0");
    }

    public long getBankInterval() {
        return 0L;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        BankNoteDetailRequestBody requestBody = request.getBody();
        BankAcnt acnt = request.getAcnt();
        String tranType = requestBody.getTranType();
        Element root = BOCOM_DC_NotePacker.packRootForNote("421101", "");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"QryAcct", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"Tp", (String)"0000");
        if ("hold".equals(subBizType)) {
            JDomUtils.addChild((Element)body, (String)"Role", (String)"3");
        } else if ("10".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"Role", (String)"4");
        } else if ("02".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"Role", (String)"9");
            JDomUtils.addChild((Element)body, (String)"QrySts", (String)"020001");
        } else if ("20".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"Role", (String)"9");
            JDomUtils.addChild((Element)body, (String)"QrySts", (String)"200001");
        } else {
            JDomUtils.addChild((Element)body, (String)"Role", (String)"9");
            JDomUtils.addChild((Element)body, (String)"QrySts", (String)"030001");
        }
        JDomUtils.addChild((Element)body, (String)"Ccy", (String)"CNY");
        JDomUtils.addChild((Element)body, (String)"IsseAmtMin", (String)"0");
        JDomUtils.addChild((Element)body, (String)"IsseAmtMax", (String)"999999999");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)body, (String)"IsseDtMin", (String)request.getBody().getStartIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)body, (String)"IsseDtMax", (String)request.getBody().getEndIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        } else {
            JDomUtils.addChild((Element)body, (String)"IsseDtMin", (String)DateUtil.formatDate((Date)DateUtil.preDay((Date)DateUtil.String2Date((String)signDate4Test), (int)60)));
            JDomUtils.addChild((Element)body, (String)"IsseDtMax", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)body, (String)"DueDtMin", (String)"");
        JDomUtils.addChild((Element)body, (String)"DueDtMax", (String)"");
        JDomUtils.addChild((Element)body, (String)"DrwrPayeeAcctId", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankAcnt acnt = request.getAcnt();
        BankNoteDetailRequestBody requestbody = request.getBody();
        String tranType = requestbody.getTranType();
        ArrayList<Detail> detailList = new ArrayList<Detail>();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (rsp.getResponseCode().equals("E014")) {
            return detailList;
        }
        Element body = ap.getChild("body");
        Element tran = body.getChild("tran");
        if (tran == null) {
            return detailList;
        }
        List rcdList = tran.getChildren("rcd");
        if (null == rcdList || rcdList.size() == 0) {
            return detailList;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de :%s\u3002", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        for (int i = 0; i < rcdList.size(); ++i) {
            Element rcd = (Element)rcdList.get(i);
            String IdNb = rcd.getChildText("IdNb");
            String Tp = rcd.getChildText("Tp");
            String IsseAmt = rcd.getChildText("IsseAmt");
            String Ccy = rcd.getChildText("Ccy");
            String IsseDt = rcd.getChildText("IsseDt");
            String DueDt = rcd.getChildText("DueDt");
            String TxlCtrctNb = rcd.getChildText("TxlCtrctNb");
            String InvcNb = rcd.getChildText("InvcNb");
            String Sts = rcd.getChildText("Sts");
            String DrwrAcctId = rcd.getChildText("DrwrAcctId");
            String DrwrAcctNm = rcd.getChildText("DrwrAcctNm");
            String PyeeAcctId = rcd.getChildText("PyeeAcctId");
            String PyeeAcctNm = rcd.getChildText("PyeeAcctNm");
            String AccptrAcctId = rcd.getChildText("AccptrAcctId");
            String AccptrNm = rcd.getChildText("AccptrNm");
            String HldrAcctId = rcd.getChildText("HldrAcctId");
            String HldrNm = rcd.getChildText("HldrNm");
            String DrwrAcctSvcrNm = rcd.getChildText("DrwrAcctSvcrNm");
            String PyeeAcctSvcrNm = rcd.getChildText("PyeeAcctSvcrNm");
            String AccptrAcctSvcrNm = rcd.getChildText("AccptrAcctSvcrNm");
            String DrwrAcctSvcr = rcd.getChildText("DrwrAcctSvcr");
            String PyeeAcctSvcr = rcd.getChildText("PyeeAcctSvcr");
            String AccptrAcctSvcr = rcd.getChildText("AccptrAcctSvcr");
            String HldrAcctSvcr = rcd.getChildText("HldrAcctSvcr");
            if (!("20".equals(tranType) && "200001".equals(Sts) || "02".equals(tranType) && "020001".equals(Sts) || "03".equals(tranType) && "030001".equals(Sts)) && (!"10".equals(tranType) || !"100001".equals(Sts))) continue;
            Detail info = new Detail();
            info.setNoteNo(IdNb);
            if (!StringUtils.isEmpty((String)IsseAmt)) {
                info.setAmount(IsseAmt);
            } else {
                info.setAmount("0");
            }
            info.setDraftType(Tp);
            info.setBusinessCode(tranType);
            info.setNoteStatus(Sts);
            if (!StringUtils.isEmpty((String)IsseDt)) {
                info.setIssueDate(IsseDt);
                info.setApplicationDate(IsseDt);
            }
            if (!StringUtils.isEmpty((String)DueDt)) {
                info.setDueDate(DueDt);
            }
            info.setTransferFlag("EM00");
            info.setDrawerAccName(DrwrAcctNm);
            info.setDrawerAccNo(DrwrAcctId);
            info.setDrawerBankName(DrwrAcctSvcrNm);
            info.setDrawerCnapsCode(DrwrAcctSvcr);
            info.setApplicantAcNo(HldrAcctId);
            info.setApplicantAcName(HldrNm);
            info.setApplicantBankCnaps(HldrAcctSvcr);
            info.setAcceptorAccName(AccptrNm);
            info.setAcceptorAccNo(AccptrAcctId);
            info.setAcceptorBankName(AccptrAcctSvcrNm);
            info.setAcceptorCnapsCode(AccptrAcctSvcr);
            info.setPayeeAccName(PyeeAcctNm);
            info.setPayeeAccNo(PyeeAcctId);
            info.setPayeeBankName(PyeeAcctSvcrNm);
            info.setPayeeCnapsCode(PyeeAcctSvcr);
            info.setCurrency("CNY");
            try {
                this.logger.info("\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u5f00\u59cb");
                EndorseInfoImpl impl = new EndorseInfoImpl();
                List<NoteSidesInfo> noteSidesInfo = impl.getMessage(IdNb, acnt.getAccNo());
                Collections.reverse(noteSidesInfo);
                this.logger.info("\u80cc\u9762\u4fe1\u606f\u6570\u91cf\uff1a" + noteSidesInfo.size());
                info.setNoteSidesInfo(noteSidesInfo);
            }
            catch (Exception e) {
                info.setIsNoteSidesError("Y");
            }
            detailList.add(info);
        }
        return detailList;
    }
}

