/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.detail;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillQsigdtbillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillQsigdtbillResponseV1;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo.EndorseInfoImpl;
import kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo.EndorseRequestInfo;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import net.sf.json.JSONObject;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u7968\u636e\u67e5\u8be2-\u67e5\u8be2\u591a\u7b14\u7968\u636e\u6982\u8981\u4fe1\u606f", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        return null;
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6682\u4e0d\u652f\u6301\u6301\u7968\u67e5\u8be2", (String)"NoteDetailImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
        }
        String URI = "mybank/enterprise/bill/qsigdtbill/V1";
        try {
            MybankEnterpriseBillQsigdtbillRequestV1.MybankEnterpriseBillQsigdtbillRequestBizV1 bizContent = new MybankEnterpriseBillQsigdtbillRequestV1.MybankEnterpriseBillQsigdtbillRequestBizV1();
            MybankEnterpriseBillQsigdtbillRequestV1 bankRequest = new MybankEnterpriseBillQsigdtbillRequestV1();
            bizContent.setTransCode("QSIGDTBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            bizContent.setNextTag(this.getFirstPageTag());
            bizContent.setSignAcctNo(request.getAcnt().getAccNo());
            bizContent.setBillType(request.getBody().getDraftType());
            String code = request.getBody().getTranType();
            String transCode = "";
            if ("02".equals(code)) {
                transCode = "NES_AC_02";
            } else if ("03".equals(code)) {
                transCode = "NES_RB_02";
            } else if ("10".equals(code)) {
                transCode = "NES_ED_02";
            } else if ("18".equals(code)) {
                transCode = "NES_PD_02";
            } else if ("20".equals(code)) {
                transCode = "CPR_PS_02";
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u672a\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
            }
            bizContent.setBusiType(transCode);
            bizContent.setDueBeginDate(LocalDateUtil.formatDate((LocalDate)request.getBody().getStartDueDate()));
            bizContent.setDueEndDate(LocalDateUtil.formatDate((LocalDate)request.getBody().getEndDueDate()));
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            MybankEnterpriseBillQsigdtbillResponseV1 response = null;
            ArrayList<Detail> result = new ArrayList<Detail>(16);
            do {
                this.logger.info("\u5f85\u7b7e\u6536\u7968\u636e\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
                response = (MybankEnterpriseBillQsigdtbillResponseV1)client.execute((IcbcRequest)bankRequest);
                this.logger.info("\u5f85\u7b7e\u6536\u7968\u636e\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                result.addAll(this.parseInfo(request, response));
                bizContent.setNextTag(this.getNextPageTag(response));
            } while (!this.isLastPage(response));
            return new EBBankDetailResponse(result);
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public List<Detail> parseInfo(BankNoteDetailRequest request, MybankEnterpriseBillQsigdtbillResponseV1 response) {
        if (!response.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ee3\u7b7e\u6536\u7968\u636e\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef", (String)"NoteDetailImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
        }
        List rds = response.getRd();
        ArrayList<Detail> result = new ArrayList<Detail>(rds.size());
        for (MybankEnterpriseBillQsigdtbillResponseV1.MybankEnterpriseBillQsigdtbillResponseRdV1 rd : rds) {
            Detail message = new Detail();
            try {
                EndorseRequestInfo info = new EndorseRequestInfo();
                info.setAccNo(request.getAcnt().getAccNo());
                info.setBillNo(rd.getCdNo());
                info.setStartNo(rd.getRangeBgn());
                info.setEndNo(rd.getRangeEnd());
                message = EndorseInfoImpl.getMessage(info);
                message.setIsNewECDS("0");
                message.setRemark(rd.getApplyRemark());
            }
            catch (Exception e) {
                message.setIsNoteSidesError("Y");
            }
            result.add(message);
        }
        return result;
    }

    public String getFirstPageTag() {
        return "0";
    }

    public String getNextPageTag(MybankEnterpriseBillQsigdtbillResponseV1 rspStr) {
        return rspStr.getNextTag();
    }

    public boolean isNeedPage() {
        return true;
    }

    public boolean isLastPage(MybankEnterpriseBillQsigdtbillResponseV1 rspStr) {
        return StringUtils.isEmpty((String)rspStr.getNextTag());
    }
}

