/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillQbasicbillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillQbasicbillResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo.Notestatus;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import net.sf.json.JSONObject;

public class NoteStatusImpl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(NoteStatusImpl.class);

    public static List<Notestatus> getMessage(BankNotePayableRequest payableRequest, BankNoteReceivableRequest receiveRequest) {
        String acntNo = "";
        String startNo = "";
        String endNo = "";
        String billNo = "";
        boolean useReceive = payableRequest == null;
        int length = useReceive ? receiveRequest.getNotePayableInfosAsArray().length : payableRequest.getNotePayableInfosAsArray().length;
        String URI = "mybank/enterprise/bill/qbasicbill/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestBizV1 bizContent = new MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestBizV1();
            MybankEnterpriseBillQbasicbillRequestV1 bankRequest = new MybankEnterpriseBillQbasicbillRequestV1();
            bizContent.setTransCode("QBASICBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            ArrayList<MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1> rds = new ArrayList<MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1>(1);
            for (int i = 0; i < length; ++i) {
                if (useReceive) {
                    acntNo = receiveRequest.getAcnt().getAccNo();
                    startNo = ((NoteReceivableInfo)receiveRequest.getNoteReceivableInfos().get(i)).getStartNo();
                    endNo = ((NoteReceivableInfo)receiveRequest.getNoteReceivableInfos().get(i)).getEndNo();
                    billNo = ((NoteReceivableInfo)receiveRequest.getNoteReceivableInfos().get(i)).getBillNo();
                } else {
                    acntNo = payableRequest.getAcnt().getAccNo();
                    startNo = ((NotePayableInfo)payableRequest.getNotePayableInfoList().get(i)).getStartNo();
                    endNo = ((NotePayableInfo)payableRequest.getNotePayableInfoList().get(i)).getEndNo();
                    billNo = ((NotePayableInfo)payableRequest.getNotePayableInfoList().get(i)).getBillNo();
                }
                MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1 rd = new MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1();
                rd.setAcctNo(acntNo);
                rd.setPackNo(billNo);
                rd.setRangeBgn(startNo);
                rd.setRangeEnd(endNo);
                rds.add(rd);
            }
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            logger.info("\u67e5\u8be2\u7968\u636e\u6b63\u80cc\u9762\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            MybankEnterpriseBillQbasicbillResponseV1 response = (MybankEnterpriseBillQbasicbillResponseV1)client.execute((IcbcRequest)bankRequest);
            logger.info("\u67e5\u8be2\u7968\u636e\u6b63\u80cc\u9762\u4fe1\u606f\u94f6\u884c\u54cd\u5e94\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            return NoteStatusImpl.parseInfo(response);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u6b63\u80cc\u9762\u4fe1\u606f\u7ed3\u679c\u672a\u77e5", (String)"NoteStatusImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
        }
    }

    public static List<Notestatus> parseInfo(MybankEnterpriseBillQbasicbillResponseV1 response) {
        ArrayList<Notestatus> result = new ArrayList<Notestatus>(16);
        if (!response.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u6b63\u9762\u4fe1\u606f\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef", (String)"NoteStatusImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
        }
        List rds = response.getRd();
        for (MybankEnterpriseBillQbasicbillResponseV1.MybankEnterpriseBillQbasicbillResponseRdV1 rd : rds) {
            Notestatus info = new Notestatus();
            info.setBillNo(rd.getPackNo());
            info.setNoteStatus(rd.getBillStatus());
            info.setNoteCirStatus(rd.getRangeStage());
            result.add(info);
        }
        return result;
    }
}

