/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.noteinfo;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillIntclapplyRequestV1;
import com.icbc.api.response.MybankEnterpriseBillIntclapplyResponseV1;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.noteinfo.atomic.AbstractNoteInfoImpl;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.business.noteinfo.bank.EBBankNoteInfoResponse;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;
import kd.ebg.note.common.framework.utils.ParserUtils;
import net.sf.json.JSONObject;

public class NoteInfoImpl
extends AbstractNoteInfoImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteInfoImpl.class);

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "intclapply";
    }

    public String getBizDesc() {
        return null;
    }

    public EBBankNoteInfoResponse doBiz(BankNoteInfoRequest request) {
        String URI = "mybank/enterprise/bill/intclapply/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        BankNoteInfoBody body = request.getBody();
        List details = body.getDetails();
        try {
            MybankEnterpriseBillIntclapplyRequestV1.MybankEnterpriseBillIntclapplyRequestBizV1 bizContent = new MybankEnterpriseBillIntclapplyRequestV1.MybankEnterpriseBillIntclapplyRequestBizV1();
            MybankEnterpriseBillIntclapplyRequestV1 bankRequest = new MybankEnterpriseBillIntclapplyRequestV1();
            bizContent.setTransCode("INTCLAPPLY");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            ArrayList<MybankEnterpriseBillIntclapplyRequestV1.MybankEnterpriseBillIntclapplyRequestRdV1> rds = new ArrayList<MybankEnterpriseBillIntclapplyRequestV1.MybankEnterpriseBillIntclapplyRequestRdV1>(1);
            for (NoteInfoDetail info : details) {
                MybankEnterpriseBillIntclapplyRequestV1.MybankEnterpriseBillIntclapplyRequestRdV1 rd = new MybankEnterpriseBillIntclapplyRequestV1.MybankEnterpriseBillIntclapplyRequestRdV1();
                rd.setPackNo(info.getNoteNo());
                rd.setRangeBgn(info.getStartNo());
                rd.setRangeEnd(info.getEndNo());
                rd.setDscntRate(info.getIncreaseRate());
                rd.setDueDate(info.getDueDate());
                if (StringUtils.isEmpty((String)info.getAmount())) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7968\u53f7\u4e3a%s\u7684\u91d1\u989d\u5b57\u6bb5\u4e3a\u7a7a", (String)"NoteInfoImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), info.getNoteNo()));
                }
                rd.setCdAmt(ParserUtils.convertYuan2CentStr((BigDecimal)new BigDecimal(info.getAmount())));
                rds.add(rd);
            }
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            logger.info("\u8d34\u73b0\u8bd5\u7b97\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            MybankEnterpriseBillIntclapplyResponseV1 response = (MybankEnterpriseBillIntclapplyResponseV1)client.execute((IcbcRequest)bankRequest);
            logger.info("\u8d34\u73b0\u8bd5\u7b97\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            return this.parse(request, response);
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public boolean match(NoteInfoRequest noteInfoRequest) {
        String isNewECDS = noteInfoRequest.getBody().getIsNewECDS();
        return "0".equals(isNewECDS);
    }

    public String pack(BankNoteInfoRequest bankNoteInfoRequest) {
        return null;
    }

    public EBBankNoteInfoResponse parse(BankNoteInfoRequest bankNoteInfoRequest, String s) {
        return null;
    }

    public EBBankNoteInfoResponse parse(BankNoteInfoRequest requset, MybankEnterpriseBillIntclapplyResponseV1 response) {
        ArrayList<NoteInfoDetail> result = new ArrayList<NoteInfoDetail>(16);
        if (response.isSuccess()) {
            List rd = response.getRd();
            for (MybankEnterpriseBillIntclapplyResponseV1.MybankEnterpriseBillIntclapplyResponseRdV1 info : rd) {
                if (StringUtils.isEmpty((String)info.getDscntInterest())) {
                    logger.info("\u7968\u53f7\u4e3a{}\u7684\u8d34\u73b0\u8bd5\u7b97\u672a\u8fd4\u56de\u7ed3\u679c\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a", new Object[]{info.getPackNo(), info.getFailMsg()});
                    continue;
                }
                NoteInfoDetail temp = new NoteInfoDetail();
                temp.setNoteNo(info.getPackNo());
                temp.setStartNo(info.getRangeBgn());
                temp.setEndNo(info.getRangeEnd());
                temp.setRecInt(info.getDscntInterest());
                result.add(temp);
            }
        } else {
            logger.info("\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u4e3a:{}", (Object)response.getReturnMsg());
        }
        EBBankNoteInfoResponse response1 = new EBBankNoteInfoResponse();
        BankNoteInfoBody body = requset.getBody();
        body.setDetails(result);
        response1.setBody(body);
        return response1;
    }

    public int getBatchSize() {
        return 10;
    }
}

