/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.payable.cancle;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillRevobillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillRevobillResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.payable.cancle.QueryCancleNotePayableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import net.sf.json.JSONObject;

public class CancleNotePayableImpl
extends AbstractNotePayableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "REVOBILL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500", (String)"CancleNotePayableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        return null;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        return null;
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        String URI = "mybank/enterprise/bill/revobill/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        List infos = request.getNotePayableInfoList();
        try {
            MybankEnterpriseBillRevobillRequestV1.MybankEnterpriseBillRevobillRequestBizV1 bizContent = new MybankEnterpriseBillRevobillRequestV1.MybankEnterpriseBillRevobillRequestBizV1();
            MybankEnterpriseBillRevobillRequestV1 bankRequest = new MybankEnterpriseBillRevobillRequestV1();
            bizContent.setTransCode("REVOBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            bizContent.setBatFlag("0");
            ArrayList<MybankEnterpriseBillRevobillRequestV1.MybankEnterpriseBillRevobillRequestRdV1> rds = new ArrayList<MybankEnterpriseBillRevobillRequestV1.MybankEnterpriseBillRevobillRequestRdV1>(1);
            for (NotePayableInfo info : infos) {
                MybankEnterpriseBillRevobillRequestV1.MybankEnterpriseBillRevobillRequestRdV1 rd = new MybankEnterpriseBillRevobillRequestV1.MybankEnterpriseBillRevobillRequestRdV1();
                rd.setPackNo(info.getBillNo());
                rd.setRangeBgn(info.getStartNo());
                rd.setRangeEnd(info.getEndNo());
                rd.setHolderAcctId(info.getDrawerAccNo());
                if ("02".equals(info.getOperationCode())) {
                    rd.setBusinessType("NES_AC_01");
                } else if ("03".equals(info.getOperationCode())) {
                    rd.setBusinessType("NES_RB_01");
                } else {
                    throw EBExceiptionUtil.serviceException((String)"unsurpport Cancle type");
                }
                rds.add(rd);
            }
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            logger.info("\u5e94\u4ed8\u64a4\u9500\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            try {
                MybankEnterpriseBillRevobillResponseV1 response = (MybankEnterpriseBillRevobillResponseV1)client.execute((IcbcRequest)bankRequest);
                logger.info("\u5e94\u4ed8\u64a4\u9500\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                return this.parse(request, response);
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public EBBankNotePayableResponse parse(BankNotePayableRequest request, MybankEnterpriseBillRevobillResponseV1 response) {
        List infos = request.getNotePayableInfoList();
        if (!response.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u64a4\u56de\u7533\u8bf7\u5931\u8d25", (String)"CancleNotePayableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            return new EBBankNotePayableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNoOut();
        for (NotePayableInfo info : infos) {
            info.setRspserialno(batSerialNo);
        }
        if (innerCode.equals("6")) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"CancleNotePayableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else if (innerCode.equals("7") || innerCode.equals("9")) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"CancleNotePayableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CancleNotePayableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        }
        return new EBBankNotePayableResponse(infos);
    }
}

