/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.payable.receive;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillColbiapplyRequestV1;
import com.icbc.api.response.MybankEnterpriseBillColbiapplyResponseV1;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.payable.receive.QueryReceiveNotePayableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import net.sf.json.JSONObject;

public class ReceiveNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiveNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryReceiveNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "COLBIAPPLY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968", (String)"ReceiveNotePayableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        return null;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        return null;
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        String URI = "mybank/enterprise/bill/colbiapply/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        List infos = request.getNotePayableInfoList();
        try {
            MybankEnterpriseBillColbiapplyRequestV1.MybankEnterpriseBillColbiapplyRequestBizV1 bizContent = new MybankEnterpriseBillColbiapplyRequestV1.MybankEnterpriseBillColbiapplyRequestBizV1();
            MybankEnterpriseBillColbiapplyRequestV1 bankRequest = new MybankEnterpriseBillColbiapplyRequestV1();
            bizContent.setTransCode("COLBIAPPLY");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            bizContent.setBookFlag("0");
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            ArrayList<MybankEnterpriseBillColbiapplyRequestV1.MybankEnterpriseBillColbiapplyRequestRdV1> rds = new ArrayList<MybankEnterpriseBillColbiapplyRequestV1.MybankEnterpriseBillColbiapplyRequestRdV1>(1);
            for (int i = 0; i < infos.size(); ++i) {
                MybankEnterpriseBillColbiapplyRequestV1.MybankEnterpriseBillColbiapplyRequestRdV1 rd = new MybankEnterpriseBillColbiapplyRequestV1.MybankEnterpriseBillColbiapplyRequestRdV1();
                rd.setDrawerAcctNo(((NotePayableInfo)infos.get(i)).getDrawerAccNo());
                rd.setPackNo(((NotePayableInfo)infos.get(i)).getBillNo());
                rd.setRangeAmt(Long.valueOf(Long.parseLong(ParserUtils.convertYuan2CentStr((BigDecimal)((NotePayableInfo)infos.get(i)).getAmount()))));
                rd.setRangeBgn(((NotePayableInfo)infos.get(i)).getStartNo());
                rd.setRangeEnd(((NotePayableInfo)infos.get(i)).getEndNo());
                rds.add(rd);
            }
            bizContent.setRd(rds);
            this.logger.info("\u63d0\u793a\u6536\u7968\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            try {
                MybankEnterpriseBillColbiapplyResponseV1 response = (MybankEnterpriseBillColbiapplyResponseV1)client.execute((IcbcRequest)bankRequest);
                this.logger.info("\u63d0\u793a\u6536\u7968\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public EBBankNotePayableResponse parse(BankNotePayableRequest rqst, MybankEnterpriseBillColbiapplyResponseV1 response) {
        List infos = rqst.getNotePayableInfoList();
        if (!response.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u51fa\u7968\u7533\u8bf7\u5931\u8d25", (String)"ReceiveNotePayableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            return new EBBankNotePayableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNo();
        for (NotePayableInfo info : infos) {
            info.setBankRefKey(info.getBankBatchSeqId());
            info.setRspserialno(batSerialNo);
        }
        switch (innerCode) {
            case "6": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"ReceiveNotePayableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "7": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"ReceiveNotePayableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "9": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ReceiveNotePayableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
        }
        EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"ReceiveNotePayableImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        return new EBBankNotePayableResponse(infos);
    }
}

