/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.payable.register;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillBiapplyRequestV1;
import com.icbc.api.request.MybankEnterpriseBillBsdrawbillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillBiapplyResponseV1;
import com.icbc.api.response.MybankEnterpriseBillBsdrawbillResponseV1;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import net.sf.json.JSONObject;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "BIAPPLY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u5904\u7406", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        NotePayableInfo[] infos = request.getNotePayableInfosAsArray();
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        String URI = "mybank/enterprise/bill/biapply/V1";
        if ("AC02".equals(infos[0].getDraftType())) {
            URI = "mybank/enterprise/bill/bsdrawbill/V1";
        }
        String acceptorBankName = infos[0].getAcceptorBankName();
        String acceptIsSame = SameBankUtil.isSameBank((String)bankVersionID, (String)acceptorBankName);
        String payeeIsSame = SameBankUtil.isSameBank((String)bankVersionID, (String)infos[0].getPayeeBankName());
        EBBankNotePayableResponse res = new EBBankNotePayableResponse();
        if ("AC01".equals(infos[0].getDraftType())) {
            try {
                MybankEnterpriseBillBiapplyRequestV1.MybankEnterpriseBillBiapplyRequestBizV1 bizContent = new MybankEnterpriseBillBiapplyRequestV1.MybankEnterpriseBillBiapplyRequestBizV1();
                MybankEnterpriseBillBiapplyRequestV1 bankRequest = new MybankEnterpriseBillBiapplyRequestV1();
                bizContent.setTransCode("BIAPPLY");
                String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
                boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
                Date date = new Date();
                if (isProduct) {
                    bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
                } else {
                    bizContent.setTranDate(signDate4Test);
                }
                bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
                bizContent.setLanguage("zh_CN");
                bizContent.setfSeqNo(request.getBankBatchSeqID());
                bizContent.setDrawerAcctNo(infos[0].getDrawerAccNo());
                bizContent.setBookFlag("0");
                bizContent.setDrawDate(infos[0].getBookingDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                bizContent.setDrawType("1");
                if (acceptIsSame.equals("1")) {
                    bizContent.setAcceptType("1");
                } else {
                    bizContent.setAcceptType("2");
                    bizContent.setAcceptName(infos[0].getAcceptorBankName());
                    bizContent.setAcceptBankNo(infos[0].getAcceptorBankCnaps());
                }
                if (!StringUtils.isEmpty((String)infos[0].getAutoAccept())) {
                    bizContent.setAutoAcceptFlag(infos[0].getAutoAccept());
                } else {
                    bizContent.setAutoAcceptFlag("0");
                }
                bizContent.setAutoReleaseFlag("0");
                if (!StringUtils.isEmpty((String)infos[0].getAutoReceive())) {
                    bizContent.setAutoFlag(infos[0].getAutoReceive());
                } else {
                    bizContent.setAutoFlag("0");
                }
                ArrayList<MybankEnterpriseBillBiapplyRequestV1.MybankEnterpriseBillBiapplyRequestRdV1> rd = new ArrayList<MybankEnterpriseBillBiapplyRequestV1.MybankEnterpriseBillBiapplyRequestRdV1>(1);
                for (int i = 0; i < infos.length; ++i) {
                    MybankEnterpriseBillBiapplyRequestV1.MybankEnterpriseBillBiapplyRequestRdV1 content = new MybankEnterpriseBillBiapplyRequestV1.MybankEnterpriseBillBiapplyRequestRdV1();
                    content.setPayeeAcctNo(infos[i].getPayeeAccNo());
                    content.setRemark(infos[i].getExplanation());
                    if (payeeIsSame.equals("1")) {
                        content.setPayeeIcbcFlag("1");
                    } else {
                        content.setPayeeIcbcFlag("0");
                        content.setPayeeAcctName(infos[i].getPayeeAccName());
                        content.setPayeeBankCode(infos[i].getPayeeBankCnaps());
                    }
                    content.setBillAmount(Long.valueOf(Long.parseLong(ParserUtils.convertYuan2CentStr((BigDecimal)infos[i].getAmount()))));
                    content.setDueDate(infos[i].getDueDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                    if (infos[i].getTransferFlag().equals("EM01")) {
                        content.setNotNegotiableFlag("0");
                    } else {
                        content.setNotNegotiableFlag("1");
                    }
                    if (StringUtils.isEmpty((String)infos[i].getGrdBag())) {
                        content.setBillSplitFlag("0");
                    } else {
                        content.setBillSplitFlag(infos[i].getGrdBag());
                    }
                    rd.add(content);
                    bizContent.setRd(rd);
                }
                bankRequest.setServiceUrl(BASE_URL + URI);
                bankRequest.setBizContent((BizContent)bizContent);
                this.logger.info("\u94f6\u7968\u51fa\u7968\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
                MybankEnterpriseBillBiapplyResponseV1 response = (MybankEnterpriseBillBiapplyResponseV1)client.execute((IcbcRequest)bankRequest);
                this.logger.info("\u94f6\u7968\u51fa\u7968\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                res = this.parsePayableDeal(request, response);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        boolean isSamePerson = infos[0].getAcceptorAccNo().equals(infos[0].getDrawerAccNo());
        try {
            MybankEnterpriseBillBsdrawbillRequestV1.MybankEnterpriseBillBsdrawbillRequestBizV1 bizContent = new MybankEnterpriseBillBsdrawbillRequestV1.MybankEnterpriseBillBsdrawbillRequestBizV1();
            MybankEnterpriseBillBsdrawbillRequestV1 businessrequest = new MybankEnterpriseBillBsdrawbillRequestV1();
            bizContent.setTransCode("BSDRAWBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            bizContent.setDrawerAcctNo(infos[0].getDrawerAccNo());
            bizContent.setBookFlag("0");
            bizContent.setDrawDate(infos[0].getBookingDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            if (isSamePerson) {
                bizContent.setAcceptType("1");
                bizContent.setAutoAcceptFlag("1");
            } else {
                bizContent.setAcceptType("2");
                bizContent.setAcceptAcctNo(infos[0].getAcceptorAccNo());
                bizContent.setAcceptName(infos[0].getAcceptorAccName());
                bizContent.setAcceptSvcr(infos[0].getAcceptorBankCnaps());
                bizContent.setAutoAcceptFlag("0");
            }
            if (acceptIsSame.equals("1")) {
                bizContent.setAcceptIsIcbc("1");
            } else {
                bizContent.setAcceptIsIcbc("0");
            }
            if (!StringUtils.isEmpty((String)infos[0].getAutoAccept())) {
                bizContent.setApplyAcceptFlag(infos[0].getAutoAccept());
            } else {
                bizContent.setAutoAcceptFlag("0");
            }
            if (!StringUtils.isEmpty((String)infos[0].getAutoReceive())) {
                bizContent.setRspAcceptSucFlag(infos[0].getAutoAccept());
            } else {
                bizContent.setRspAcceptSucFlag("0");
            }
            bizContent.setGuarntFlag("0");
            ArrayList<MybankEnterpriseBillBsdrawbillRequestV1.MybankEnterpriseBillBsdrawbillRequestRdV1> rd = new ArrayList<MybankEnterpriseBillBsdrawbillRequestV1.MybankEnterpriseBillBsdrawbillRequestRdV1>(1);
            for (int i = 0; i < infos.length; ++i) {
                MybankEnterpriseBillBsdrawbillRequestV1.MybankEnterpriseBillBsdrawbillRequestRdV1 content = new MybankEnterpriseBillBsdrawbillRequestV1.MybankEnterpriseBillBsdrawbillRequestRdV1();
                content.setPayeeAcctNo(infos[i].getPayeeAccNo());
                content.setRemark(infos[i].getExplanation());
                if (payeeIsSame.equals("1")) {
                    content.setPayeeIsIcbc("1");
                } else {
                    content.setPayeeIsIcbc("0");
                    content.setPayeeName(infos[i].getPayeeAccName());
                    content.setPayeeSvcr(infos[i].getPayeeBankCnaps());
                }
                content.setBillAmount(Long.valueOf(Long.parseLong(ParserUtils.convertYuan2CentStr((BigDecimal)infos[i].getAmount()))));
                content.setBillDueDate(infos[i].getDueDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                if (infos[i].getTransferFlag().equals("EM01")) {
                    content.setNotNegotiableFlag("0");
                } else {
                    content.setNotNegotiableFlag("1");
                }
                if (StringUtils.isEmpty((String)infos[i].getGrdBag())) {
                    content.setBillSplitFlag("0");
                } else {
                    content.setBillSplitFlag(infos[i].getGrdBag());
                }
                rd.add(content);
                bizContent.setRd(rd);
            }
            businessrequest.setServiceUrl(BASE_URL + URI);
            businessrequest.setBizContent((BizContent)bizContent);
            this.logger.info("\u5546\u7968\u51fa\u7968\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)businessrequest).toString());
            try {
                MybankEnterpriseBillBsdrawbillResponseV1 response = (MybankEnterpriseBillBsdrawbillResponseV1)client.execute((IcbcRequest)businessrequest);
                this.logger.info("\u5546\u7968\u51fa\u7968\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                res = this.parseBusinessPayableDeal(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
        return res;
    }

    public EBBankNotePayableResponse parseBusinessPayableDeal(BankNotePayableRequest rqst, MybankEnterpriseBillBsdrawbillResponseV1 response) {
        List infos = rqst.getNotePayableInfoList();
        if (!response.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u51fa\u7968\u7533\u8bf7\u5931\u8d25", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            return new EBBankNotePayableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNo();
        for (NotePayableInfo info : infos) {
            info.setObssid(batSerialNo);
        }
        switch (innerCode) {
            case "6": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "7": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"RegisterNotePayableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "9": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RegisterNotePayableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
        }
        EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"RegisterNotePayableImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        return new EBBankNotePayableResponse(infos);
    }

    public EBBankNotePayableResponse parsePayableDeal(BankNotePayableRequest rqst, MybankEnterpriseBillBiapplyResponseV1 response) {
        List infos = rqst.getNotePayableInfoList();
        if (!response.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u51fa\u7968\u7533\u8bf7\u5931\u8d25", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            return new EBBankNotePayableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNo();
        for (NotePayableInfo info : infos) {
            info.setBankRefKey(info.getBankBatchSeqId());
            info.setRspserialno(batSerialNo);
        }
        switch (innerCode) {
            case "6": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "7": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"RegisterNotePayableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "9": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RegisterNotePayableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
        }
        EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"RegisterNotePayableImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        return new EBBankNotePayableResponse(infos);
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        return null;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        return null;
    }
}

