/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.payable.revocation;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillAdstbillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillAdstbillResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.payable.revocation.QueryRevocationNotePayableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import net.sf.json.JSONObject;

public class RevocationNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RevocationNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRevocationNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ADSTBILL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u7968", (String)"RevocationNotePayableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        return null;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        return null;
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        String URI = "mybank/enterprise/bill/adstbill/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        List infos = request.getNotePayableInfoList();
        try {
            MybankEnterpriseBillAdstbillRequestV1.MybankEnterpriseBillAdstbillRequestBizV1 bizContent = new MybankEnterpriseBillAdstbillRequestV1.MybankEnterpriseBillAdstbillRequestBizV1();
            MybankEnterpriseBillAdstbillRequestV1 bankRequest = new MybankEnterpriseBillAdstbillRequestV1();
            bizContent.setTransCode("ADSTBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            bizContent.setRemark("null");
            ArrayList<MybankEnterpriseBillAdstbillRequestV1.MybankEnterpriseBillAdstbillRequestRdV1> rds = new ArrayList<MybankEnterpriseBillAdstbillRequestV1.MybankEnterpriseBillAdstbillRequestRdV1>(16);
            for (NotePayableInfo info : infos) {
                MybankEnterpriseBillAdstbillRequestV1.MybankEnterpriseBillAdstbillRequestRdV1 rd = new MybankEnterpriseBillAdstbillRequestV1.MybankEnterpriseBillAdstbillRequestRdV1();
                rd.setDrwrAcctId(info.getDrawerAccNo());
                rd.setRangeBgn(info.getStartNo());
                rd.setRangeEnd(info.getEndNo());
                rd.setPackNo(info.getBillNo());
                rds.add(rd);
            }
            bankRequest.setServiceUrl(BASE_URL + URI);
            bizContent.setRd(rds);
            bankRequest.setBizContent((BizContent)bizContent);
            this.logger.info("\u64a4\u7968\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            try {
                MybankEnterpriseBillAdstbillResponseV1 response = (MybankEnterpriseBillAdstbillResponseV1)client.execute((IcbcRequest)bankRequest);
                this.logger.info("\u64a4\u7968\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public EBBankNotePayableResponse parse(BankNotePayableRequest request, MybankEnterpriseBillAdstbillResponseV1 response) {
        List infos = request.getNotePayableInfoList();
        if (!response.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u64a4\u7968\u7533\u8bf7\u5931\u8d25", (String)"RevocationNotePayableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            return new EBBankNotePayableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNo();
        for (NotePayableInfo info : infos) {
            info.setObssid(batSerialNo);
        }
        switch (innerCode) {
            case "6": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"RevocationNotePayableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "7": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"RevocationNotePayableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "9": {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RevocationNotePayableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
        }
        EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"RevocationNotePayableImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        return new EBBankNotePayableResponse(infos);
    }
}

