/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.receivable.discount;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillDsctbilappRequestV1;
import com.icbc.api.response.MybankEnterpriseBillDsctbilappResponseV1;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import net.sf.json.JSONObject;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DiscountNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DSCTBILAPP";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u8d34\u73b0", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        return null;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        return null;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String URI = "mybank/enterprise/bill/dsctbilapp/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        List infos = request.getNoteReceivableInfos();
        try {
            MybankEnterpriseBillDsctbilappRequestV1.MybankEnterpriseBillDsctbilappRequestBizV1 bizContent = new MybankEnterpriseBillDsctbilappRequestV1.MybankEnterpriseBillDsctbilappRequestBizV1();
            MybankEnterpriseBillDsctbilappRequestV1 bankRequest = new MybankEnterpriseBillDsctbilappRequestV1();
            bizContent.setTransCode("DSCTBILAPP");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            bizContent.setHolderAcctId(((NoteReceivableInfo)infos.get(0)).getAcceptorAccNo());
            String oppSameBank = SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)((NoteReceivableInfo)infos.get(0)).getPayeeBankName());
            bizContent.setIfDscntIcbc(oppSameBank);
            String accSameBank = SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)((NoteReceivableInfo)infos.get(0)).getAcceptorBankName());
            if (accSameBank.equals("0")) {
                bizContent.setEtyAccType("2");
                bizContent.setEtyAccId(((NoteReceivableInfo)infos.get(0)).getAcceptorBankCnaps());
            } else {
                bizContent.setEtyAccType("1");
                bizContent.setEtyAccId(((NoteReceivableInfo)infos.get(0)).getAcceptorAccNo());
            }
            bizContent.setEtyAccName(((NoteReceivableInfo)infos.get(0)).getAcceptorAccName());
            bizContent.setDscntBkAcc(((NoteReceivableInfo)infos.get(0)).getPayeeAccNo());
            bizContent.setDscntBkBakno(((NoteReceivableInfo)infos.get(0)).getPayeeBankCnaps());
            bizContent.setIfTransAllow(((NoteReceivableInfo)infos.get(0)).getTransferFlag());
            bizContent.setDscntType("RM00");
            bizContent.setLoanUsage(((NoteReceivableInfo)infos.get(0)).getExplanation());
            if (((NoteReceivableInfo)infos.get(0)).getAutoAccept().equals("0")) {
                bizContent.setLiquidMethod("SM00");
                if (oppSameBank.equals("1")) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u5165\u4eba\u662f\u5de5\u884c\u65f6\uff0c\u5fc5\u987b\u662f\u7ebf\u4e0b\u6e05\u7b97", (String)"DiscountNoteReceivableImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
                }
            } else {
                bizContent.setLiquidMethod("SM01");
            }
            bizContent.setIfPack("0");
            if (!"1".equals(((NoteReceivableInfo)infos.get(0)).getDiscountType())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u53ea\u652f\u6301\u6301\u7968\u4eba\u4ed8\u606f", (String)"DiscountNoteReceivableImpl_6", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
            }
            bizContent.setInterestType("01");
            ArrayList<MybankEnterpriseBillDsctbilappRequestV1.MybankEnterpriseBillDsctbilappRequestRdV1> rds = new ArrayList<MybankEnterpriseBillDsctbilappRequestV1.MybankEnterpriseBillDsctbilappRequestRdV1>(16);
            for (NoteReceivableInfo info : infos) {
                MybankEnterpriseBillDsctbilappRequestV1.MybankEnterpriseBillDsctbilappRequestRdV1 rd = new MybankEnterpriseBillDsctbilappRequestV1.MybankEnterpriseBillDsctbilappRequestRdV1();
                rd.setPackNo(info.getBillNo());
                rd.setRangeBgn(info.getStartNo());
                rd.setRangeEnd(info.getEndNo());
                rd.setTradeRate(info.getDisCountRate());
                rd.setDscntAmt(Long.valueOf(Long.parseLong(ParserUtils.convertYuan2CentStr((BigDecimal)info.getAmount()))));
                rds.add(rd);
            }
            String invcAmt = ((NoteReceivableInfo)infos.get(0)).getInvcAmt();
            if (StringUtils.isNotEmpty((String)invcAmt)) {
                ArrayList<MybankEnterpriseBillDsctbilappRequestV1.TicketInfo> ticketList = new ArrayList<MybankEnterpriseBillDsctbilappRequestV1.TicketInfo>(1);
                MybankEnterpriseBillDsctbilappRequestV1.TicketInfo ticket = new MybankEnterpriseBillDsctbilappRequestV1.TicketInfo();
                ticket.setInvcType(((NoteReceivableInfo)infos.get(0)).getInvcType());
                ticket.setInvcNo(((NoteReceivableInfo)infos.get(0)).getInvcNo());
                ticket.setInvcCode(((NoteReceivableInfo)infos.get(0)).getInvcCode());
                ticket.setInvcAmt(Long.valueOf(Long.parseLong(ParserUtils.convertYuan2CentStr((BigDecimal)new BigDecimal(invcAmt)))));
                ticket.setInvcDate(((NoteReceivableInfo)infos.get(0)).getInvcDate());
                if ("004".equals(((NoteReceivableInfo)infos.get(0)).getInvcType()) || "007".equals(((NoteReceivableInfo)infos.get(0)).getInvcType())) {
                    String invcChkNo = ((NoteReceivableInfo)infos.get(0)).getInvcChkNo();
                    if (StringUtils.isEmpty((String)invcChkNo)) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u6216\u666e\u7968\u65f6\u53d1\u7968\u6821\u9a8c\u7801\u5fc5\u8f93", (String)"DiscountNoteReceivableImpl_7", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
                    }
                    ticket.setInvcChkNo(invcChkNo);
                }
                ticketList.add(ticket);
                bizContent.setTicketList(ticketList);
            }
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            this.logger.info("\u8d34\u73b0\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            try {
                MybankEnterpriseBillDsctbilappResponseV1 response = (MybankEnterpriseBillDsctbilappResponseV1)client.execute((IcbcRequest)bankRequest);
                this.logger.info("\u8d34\u73b0\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public EBBankNoteReceivableResponse parse(BankNoteReceivableRequest request, MybankEnterpriseBillDsctbilappResponseV1 response) {
        List infos = request.getNoteReceivableInfos();
        if (!response.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u8d34\u73b0\u7533\u8bf7\u5931\u8d25", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            return new EBBankNoteReceivableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNo();
        for (NoteReceivableInfo info : infos) {
            info.setBankRefKey(info.getBankBatchSeqId());
            info.setRspserialno(batSerialNo);
        }
        if (innerCode.equals("6")) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u8d34\u73b0\u88ab\u94f6\u884c\u62d2\u7edd", (String)"DiscountNoteReceivableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else if (innerCode.equals("7") || innerCode.equals("9")) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u8d34\u73b0\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"DiscountNoteReceivableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8d34\u73b0\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"DiscountNoteReceivableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        }
        return new EBBankNoteReceivableResponse(infos);
    }
}

