/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.receivable.endorse;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillEndtbilappRequestV1;
import com.icbc.api.response.MybankEnterpriseBillEndtbilappResponseV1;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.receivable.endorse.QueryEndorseNoteReceivableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import net.sf.json.JSONObject;

public class EndorseNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryEndorseNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ENDTBILAPP";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u80cc\u4e66", (String)"EndorseNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        return null;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        return null;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String URI = "mybank/enterprise/bill/endtbilapp/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        List infos = request.getNoteReceivableInfos();
        try {
            MybankEnterpriseBillEndtbilappRequestV1.MybankEnterpriseBillEndtbilappRequestBizV1 bizContent = new MybankEnterpriseBillEndtbilappRequestV1.MybankEnterpriseBillEndtbilappRequestBizV1();
            MybankEnterpriseBillEndtbilappRequestV1 bankRequest = new MybankEnterpriseBillEndtbilappRequestV1();
            bizContent.setTransCode("ENDTBILAPP");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            bizContent.setApplyType("1");
            ArrayList<MybankEnterpriseBillEndtbilappRequestV1.MybankEnterpriseBillEndtbilappRequestRdV1> rds = new ArrayList<MybankEnterpriseBillEndtbilappRequestV1.MybankEnterpriseBillEndtbilappRequestRdV1>(16);
            for (NoteReceivableInfo info : infos) {
                MybankEnterpriseBillEndtbilappRequestV1.MybankEnterpriseBillEndtbilappRequestRdV1 rd = new MybankEnterpriseBillEndtbilappRequestV1.MybankEnterpriseBillEndtbilappRequestRdV1();
                rd.setNotNegotiableFlag(info.getTransferFlag());
                rd.setPackNo(info.getBillNo());
                rd.setRangeBgn(info.getStartNo());
                rd.setRangeEnd(info.getEndNo());
                rd.setEndrsrAcctId(request.getAcnt().getAccNo());
                String flag = SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getPayeeBankName());
                rd.setEndrseeIsIcbc(flag);
                rd.setEndrseeAcctId(info.getPayeeAccNo());
                rd.setEndrseeName(info.getPayeeAccName());
                rd.setPayRemark(info.getExplanation());
                if (flag.equals("0")) {
                    rd.setEndrseeAcctSvcr(info.getPayeeBankCnaps());
                }
                rd.setTransAmount(Long.valueOf(Long.parseLong(ParserUtils.convertYuan2CentStr((BigDecimal)info.getAmount()))));
                rds.add(rd);
            }
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            this.logger.info("\u80cc\u4e66\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            try {
                MybankEnterpriseBillEndtbilappResponseV1 response = (MybankEnterpriseBillEndtbilappResponseV1)client.execute((IcbcRequest)bankRequest);
                this.logger.info("\u80cc\u4e66\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public EBBankNoteReceivableResponse parse(BankNoteReceivableRequest request, MybankEnterpriseBillEndtbilappResponseV1 response) {
        List infos = request.getNoteReceivableInfos();
        if (!response.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5931\u8d25", (String)"EndorseNoteReceivableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            return new EBBankNoteReceivableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNo();
        for (NoteReceivableInfo info : infos) {
            info.setBankRefKey(info.getBankBatchSeqId());
            info.setRspserialno(batSerialNo);
        }
        if (innerCode.equals("6")) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"EndorseNoteReceivableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else if (innerCode.equals("7") || innerCode.equals("9")) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"EndorseNoteReceivableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"EndorseNoteReceivableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        }
        return new EBBankNoteReceivableResponse(infos);
    }
}

