/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.util;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillQbillinsRequestV1;
import com.icbc.api.response.MybankEnterpriseBillQbillinsResponseV1;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.banks.icbc.opa.service.note.util.ICBC_OPA_Parser;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import net.sf.json.JSONObject;

public class ICBC_OPA_Packer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_OPA_Packer.class);

    public static void doQueryReceive(BankNoteReceivableRequest request, String type) {
        String URI = "mybank/enterprise/bill/qbillins/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseBillQbillinsRequestV1.MybankEnterpriseBillQbillinsRequestBizV1 bizContent = new MybankEnterpriseBillQbillinsRequestV1.MybankEnterpriseBillQbillinsRequestBizV1();
            MybankEnterpriseBillQbillinsRequestV1 bankRequest = new MybankEnterpriseBillQbillinsRequestV1();
            bizContent.setTransCode("QBILLINS");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            bizContent.setQryfSeqno(request.getBankBatchSeqID());
            bizContent.setQryTransCode(type);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            logger.info("\u901a\u7528\u540c\u6b65\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            MybankEnterpriseBillQbillinsResponseV1 response = (MybankEnterpriseBillQbillinsResponseV1)client.execute((IcbcRequest)bankRequest);
            logger.info("\u901a\u7528\u540c\u6b65\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            ICBC_OPA_Parser.parseReceiveInfo(request, response);
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public static void doQueryPayable(BankNotePayableRequest request, String type) {
        String URI = "mybank/enterprise/bill/qbillins/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseBillQbillinsRequestV1.MybankEnterpriseBillQbillinsRequestBizV1 bizContent = new MybankEnterpriseBillQbillinsRequestV1.MybankEnterpriseBillQbillinsRequestBizV1();
            MybankEnterpriseBillQbillinsRequestV1 bankRequest = new MybankEnterpriseBillQbillinsRequestV1();
            bizContent.setTransCode("QBILLINS");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            bizContent.setQryfSeqno(request.getBankBatchSeqID());
            bizContent.setQryTransCode(type);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            logger.info("\u901a\u7528\u540c\u6b65\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            MybankEnterpriseBillQbillinsResponseV1 response = (MybankEnterpriseBillQbillinsResponseV1)client.execute((IcbcRequest)bankRequest);
            logger.info("\u901a\u7528\u540c\u6b65\u7533\u8bf7\u94f6\u884c\u54cd\u5e94\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            ICBC_OPA_Parser.parsePayableInfo(request, response);
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }
}

