/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DCNoteResponse;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.NoteStatusInfo;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.banks.abc.dc.utils.NoteStatusUtils;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CommQueryParser {
    public static String packQueryStatusString(List<NoteReceivableInfo> infos, String bizType) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQRM37");
        Element header = CommNotePacker.packNoteHeader(root, "5422");
        NoteReceivableInfo info = infos.get(0);
        JDomUtils.addChild((Element)header, (String)"ClientId", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)header, (String)"BillNo", (String)info.getBillNo());
        JDomUtils.addChild((Element)header, (String)"BillClass", (String)"BC0001");
        JDomUtils.addChild((Element)header, (String)"AllBussType", (String)bizType);
        String time = info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)header, (String)"StartDate", (String)time);
        JDomUtils.addChild((Element)header, (String)"EndDate", (String)time);
        JDomUtils.addChild((Element)header, (String)"BatchNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)header, (String)"Note", (String)info.getExplanation());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static String packQueryStatusStringPay(List<NotePayableInfo> infos, String bizType) {
        Element root = ABC_DC_Packer.createABCRoot("CQRM37");
        Element header = CommNotePacker.packNoteHeader(root, "5422");
        NotePayableInfo info = infos.get(0);
        JDomUtils.addChild((Element)header, (String)"ClientId", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)header, (String)"BillNo", (String)info.getBillNo());
        JDomUtils.addChild((Element)header, (String)"BillClass", (String)"BC0001");
        String time = info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)header, (String)"StartDate", (String)time);
        JDomUtils.addChild((Element)header, (String)"EndDate", (String)time);
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"SerialSeqNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)header, (String)"BatchNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)header, (String)"Note", (String)info.getExplanation());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static void queryNoteStatusPay(List<NotePayableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equals(rspCode)) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
        Element billDealInfoList = JDomUtils.getChildElement((Element)hermes, (String)"BillDealInfoList");
        List billDealList = billDealInfoList.getChildren("BillDealInfo");
        Map<String, NoteStatusInfo> resultMap = CommQueryParser.parserMap(billDealList);
        for (NotePayableInfo info : infos) {
            NoteStatusInfo statusInfo = resultMap.get(info.getBillNo());
            if (null == statusInfo) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                continue;
            }
            if (statusInfo.isSuccess()) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)statusInfo.getBankCode(), (String)statusInfo.getBankMsg());
                continue;
            }
            if (statusInfo.isUnkonwn()) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)statusInfo.getBankCode(), (String)statusInfo.getBankMsg());
                continue;
            }
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)statusInfo.getBankCode(), (String)statusInfo.getBankMsg());
        }
    }

    public static void queryNoteStatus(List<NoteReceivableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equals(rspCode)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
        Element billDealInfoList = JDomUtils.getChildElement((Element)hermes, (String)"BillDealInfoList");
        List billDealList = billDealInfoList.getChildren("BillDealInfo");
        Map<String, NoteStatusInfo> resultMap = CommQueryParser.parserMap(billDealList);
        for (NoteReceivableInfo info : infos) {
            NoteStatusInfo statusInfo = resultMap.get(info.getBillNo());
            if (null == statusInfo) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                continue;
            }
            if (statusInfo.isSuccess()) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)statusInfo.getBankCode(), (String)statusInfo.getBankMsg());
                continue;
            }
            if (statusInfo.isUnkonwn()) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)statusInfo.getBankCode(), (String)statusInfo.getBankMsg());
                continue;
            }
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)statusInfo.getBankCode(), (String)statusInfo.getBankMsg());
        }
    }

    private static Map<String, NoteStatusInfo> parserMap(List<Element> dealList) {
        HashMap<String, NoteStatusInfo> resultMap = new HashMap<String, NoteStatusInfo>(1);
        for (Element info : dealList) {
            String billNo = JDomUtils.getChildText((Element)info, (String)"BillNo");
            String taskState = JDomUtils.getChildText((Element)info, (String)"TaskState");
            String busCode = JDomUtils.getChildText((Element)info, (String)"BussCode");
            NoteStatusInfo statusInfo = new NoteStatusInfo();
            statusInfo.setBankCode(busCode);
            statusInfo.setBankMsg(taskState);
            if (ResManager.loadKDString((String)"\u672a\u5904\u7406", (String)"CommQueryParser_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(taskState)) {
                statusInfo.setSuccess(false);
                statusInfo.setUnkonwn(true);
            } else if (ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"CommQueryParser_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(taskState)) {
                statusInfo.setSuccess(true);
                statusInfo.setUnkonwn(false);
            } else {
                statusInfo.setSuccess(false);
                statusInfo.setUnkonwn(true);
            }
            resultMap.put(billNo, statusInfo);
        }
        return resultMap;
    }

    public static String packQueryPayUseBillNoPay(List<NotePayableInfo> infos) {
        NotePayableInfo info = infos.get(0);
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRT14");
        Element hermes = CommNotePacker.packNoteHeader(root, "1017");
        CommNotePacker.packCmpElement(root, acnt);
        JDomUtils.addChild((Element)hermes, (String)"BillTyp", (String)info.getDraftType());
        if (StringUtils.isEmpty((String)info.getBillNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f3a\u5c11\u7968\u636e\u53f7\u67e5\u8be2\u67e5\u8be2\u6761\u4ef6\u3002", (String)"CommQueryParser_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)hermes, (String)"IdNb", (String)info.getBillNo());
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"ContLast");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static Map<String, ABC_DCNoteResponse> parseQueryPayUseBillNoPay(List<NotePayableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equals(rspCode)) {
            return null;
        }
        HashMap<String, ABC_DCNoteResponse> statusMap = new HashMap<String, ABC_DCNoteResponse>();
        Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
        Element ebinfo = JDomUtils.getChildElement((Element)hermes, (String)"EBInfo");
        String billStatus = JDomUtils.getChildText((Element)ebinfo, (String)"BillSta");
        String billNo = JDomUtils.getChildText((Element)ebinfo, (String)"IdNb");
        if (!StringUtils.isEmpty((String)billNo)) {
            ABC_DCNoteResponse response = new ABC_DCNoteResponse();
            response.setBillNo(billNo);
            response.setNoteStatus(billStatus);
            response.setResponseCode(billStatus);
            response.setResponseMessage(NoteStatusUtils.getNoteStatusMsg(billStatus));
            statusMap.put(billNo, response);
        }
        return statusMap;
    }

    private static Map<String, ABC_DCNoteResponse> getNoteStatusMapUseBillNo(String[] splits, int recordNum) {
        HashMap<String, ABC_DCNoteResponse> result = new HashMap<String, ABC_DCNoteResponse>(1);
        for (int i = 0; i < recordNum; ++i) {
            String billNo = splits[i * recordNum];
            String billAmount = splits[i * recordNum + 1];
            String payeeAccNo = splits[i * recordNum + 2];
            String noteStatus = splits[i * recordNum + 4];
            String bathNo = splits[i * recordNum + 5];
            String status = splits[i * recordNum + 8];
            String bankMsg = splits[i * recordNum + 9];
            ABC_DCNoteResponse response = new ABC_DCNoteResponse();
            response.setBillNo(billNo);
            response.setNoteStatus(noteStatus);
            response.setResponseMessage(bankMsg + NoteStatusUtils.getNoteStatusMsg(noteStatus));
            result.put(billNo, response);
        }
        return result;
    }

    public static void setNoteStatusUseBillNoPay(List<NotePayableInfo> infos, Map<String, ABC_DCNoteResponse> paseredMap, String[] successCodes, String[] failedCodes) {
        if (null != paseredMap) {
            for (NotePayableInfo info : infos) {
                ABC_DCNoteResponse response = paseredMap.get(info.getBillNo());
                if (null != response) {
                    info.setNoteStatus(response.getNoteStatus());
                    if (MatchUtils.match(successCodes, response.getNoteStatus())) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    if (MatchUtils.match(failedCodes, response.getNoteStatus())) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6d41\u6c34\u4e2d\u672a\u5305\u542b\u6b64\u7b14\u7968\u636e\u4fe1\u606f\u3002", (String)"CommQueryParser_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u6b21\u67e5\u8be2\u6b64\u7b14\u7968\u636e\u72b6\u6001\uff0c\u6216\u4e0e\u94f6\u884c\u65b9\u786e\u8ba4\u3002", (String)"CommQueryParser_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            }
        }
    }

    public static String packQueryPayUseBillNo(List<NoteReceivableInfo> infos) {
        NoteReceivableInfo info = infos.get(0);
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRT14");
        Element hermes = CommNotePacker.packNoteHeader(root, "1017");
        CommNotePacker.packCmpElement(root, acnt);
        JDomUtils.addChild((Element)hermes, (String)"BillTyp", (String)info.getDraftType());
        if (StringUtils.isEmpty((String)info.getBillNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f3a\u5c11\u7968\u636e\u53f7\u67e5\u8be2\u67e5\u8be2\u6761\u4ef6\u3002", (String)"CommQueryParser_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)hermes, (String)"IdNb", (String)info.getBillNo());
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"ContLast");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static Map<String, ABC_DCNoteResponse> parseQueryPayUseBillNo(List<NoteReceivableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equals(rspCode)) {
            return null;
        }
        HashMap<String, ABC_DCNoteResponse> statusMap = new HashMap<String, ABC_DCNoteResponse>();
        Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
        Element ebinfo = JDomUtils.getChildElement((Element)hermes, (String)"EBInfo");
        String billStatus = JDomUtils.getChildText((Element)ebinfo, (String)"BillSta");
        String billNo = JDomUtils.getChildText((Element)ebinfo, (String)"IdNb");
        if (!StringUtils.isEmpty((String)billNo)) {
            ABC_DCNoteResponse response = new ABC_DCNoteResponse();
            response.setBillNo(billNo);
            response.setNoteStatus(billStatus);
            response.setResponseCode(billStatus);
            response.setResponseMessage(NoteStatusUtils.getNoteStatusMsg(billStatus));
            statusMap.put(billNo, response);
        }
        return statusMap;
    }

    public static void setNoteStatusUseBillNo(List<NoteReceivableInfo> infos, Map<String, ABC_DCNoteResponse> paseredMap, String[] successCodes, String[] failedCodes) {
        if (null != paseredMap) {
            for (NoteReceivableInfo info : infos) {
                ABC_DCNoteResponse response = paseredMap.get(info.getBillNo());
                if (null != response) {
                    info.setNoteStatus(response.getNoteStatus());
                    if (MatchUtils.match(successCodes, response.getNoteStatus())) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    if (MatchUtils.match(failedCodes, response.getNoteStatus())) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6d41\u6c34\u4e2d\u672a\u5305\u542b\u6b64\u7b14\u7968\u636e\u4fe1\u606f\u3002", (String)"CommQueryParser_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u6b21\u67e5\u8be2\u6b64\u7b14\u7968\u636e\u72b6\u6001\uff0c\u6216\u4e0e\u94f6\u884c\u65b9\u786e\u8ba4\u3002", (String)"CommQueryParser_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            }
        }
    }
}

