/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service;

import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.note.banks.abc.dc.service.note.detail.flow.NoteFlowImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class QueryNoteStatusUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNoteStatusUtils.class);

    private static String getABCBuscode(String ebBuscode) {
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append("0").append(ebBuscode);
        return sBuffer.toString();
    }

    public static void setNoteStatus(List<NoteReceivableInfo> infos, String bizType) {
        for (NoteReceivableInfo info : infos) {
            BankNoteDetailRequest request = new BankNoteDetailRequest();
            BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
            body.setNoteNo(info.getBillNo());
            body.setTranType("EBG_YQ");
            request.setBody(body);
            NoteFlowImpl flowImpl = new NoteFlowImpl();
            List result = flowImpl.detail(request).getDetails();
            QueryNoteStatusUtils.setStatus((List<Detail>)result, info, info.getPayeeAccNo(), bizType);
        }
    }

    public static void setNoteStatus(List<NoteReceivableInfo> infos, String bizType, String accNo) {
        for (NoteReceivableInfo info : infos) {
            BankNoteDetailRequest request = new BankNoteDetailRequest();
            BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
            body.setNoteNo(info.getBillNo());
            body.setTranType("EBG_YQ");
            BankHeader header = new BankHeader();
            header.setSubBizType("flow");
            request.setHeader(header);
            request.setBody(body);
            NoteFlowImpl flowImpl = new NoteFlowImpl();
            List result = flowImpl.doBiz(request).getDetails();
            QueryNoteStatusUtils.setStatus((List<Detail>)result, info, accNo, bizType);
        }
    }

    private static void setStatus(List<Detail> detailInfos, NotePayableInfo info, String accNo, String bizType) {
        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u64cd\u4f5c\u72b6\u6001\u672a\u77e5", (String)"QueryNoteStatusUtils_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001", (String)"QueryNoteStatusUtils_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        block0: for (Detail detailInfo : detailInfos) {
            List details = detailInfo.getNoteSidesInfo();
            if (null == details || details.size() <= 0) continue;
            for (NoteSidesInfo detail : details) {
                String tSubmitSuccessTime = info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                if (!detail.getSubType().equals(QueryNoteStatusUtils.getABCBuscode(bizType)) || !accNo.equals(detail.getAccountNo()) || QueryNoteStatusUtils.compareDateUsingyyyyMMdd(tSubmitSuccessTime, detail.getSignDate()) == 1) continue;
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u64cd\u4f5c\u6210\u529f", (String)"QueryNoteStatusUtils_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bf9\u65b9\u7b7e\u6536\u6210\u529f", (String)"QueryNoteStatusUtils_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
                continue block0;
            }
        }
    }

    private static void setStatus(List<Detail> detailInfos, NoteReceivableInfo info, String accNo, String bizType) {
        for (Detail detailInfo : detailInfos) {
            Boolean isMatch = false;
            List details = detailInfo.getNoteSidesInfo();
            if (null != details && details.size() > 0) {
                for (NoteSidesInfo detail : details) {
                    logger.info("\u4e1a\u52a1\u53f7:" + detail.getSubType() + "," + QueryNoteStatusUtils.getABCBuscode(bizType));
                    logger.info("\u8d26\u53f7:" + accNo + "," + detail.getAccountNo());
                    logger.info("\u65f6\u95f4:" + info.getSubmitSuccessTime() + "," + detail.getSignDate());
                    String tSubmitSuccessTime = info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    if (!detail.getSubType().equals(QueryNoteStatusUtils.getABCBuscode(bizType)) || !accNo.equals(detail.getAccountNo()) || QueryNoteStatusUtils.compareDateUsingyyyyMMdd(tSubmitSuccessTime, detail.getSignDate()) == 1) continue;
                    isMatch = true;
                    logger.info("\u5339\u914d\u6210\u529f\uff1a\u7968\u636e\u53f7\uff1a" + info.getBillNo() + ",\u5bf9\u65b9\u8d26\u53f7\uff1a" + accNo + "");
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u64cd\u4f5c\u6210\u529f", (String)"QueryNoteStatusUtils_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bf9\u65b9\u7b7e\u6536\u6210\u529f", (String)"QueryNoteStatusUtils_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
                    logger.info("\u5339\u914d\u6210\u529f\uff1a\u66f4\u65b0\u72b6\u6001\u7968\u636e\u53f7\uff1a" + info.getBillNo() + ",\u5bf9\u65b9\u7b7e\u6536\u6210\u529f");
                    break;
                }
            }
            if (isMatch.booleanValue()) continue;
            logger.info("\u5339\u914d\u672a\u6210\u529f");
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u627e\u4e0d\u5230\u8be5\u4ea4\u6613\u8bb0\u5f55\uff0c\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryNoteStatusUtils_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u627e\u4e0d\u5230\u8be5\u4ea4\u6613\u8bb0\u5f55\uff0c\u4ea4\u6613\u72b6\u6001\u672a\u77e5\u3002", (String)"QueryNoteStatusUtils_7", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
    }

    public static void setNoteStatusPay(List<NotePayableInfo> infos, String bizType) {
        for (NotePayableInfo info : infos) {
            BankNoteDetailRequest request = new BankNoteDetailRequest();
            BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
            body.setNoteNo(info.getBillNo());
            body.setTranType("EBG_YQ");
            request.setBody(body);
            NoteFlowImpl flowImpl = new NoteFlowImpl();
            List result = flowImpl.detail(request).getDetails();
            QueryNoteStatusUtils.setStatus((List<Detail>)result, info, info.getPayeeAccNo(), bizType);
        }
    }

    private static int compareDateUsingyyyyMMdd(String date1, String date2) {
        int flag = 0;
        try {
            Date dateTemp1 = DateTimeUtils.parseDate((String)date1, (String)"yyyy-MM-dd");
            Date dateTemp2 = DateTimeUtils.parseDate((String)date2, (String)"yyyy-MM-dd");
            flag = dateTemp1.compareTo(dateTemp2);
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return flag;
    }
}

