/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.detail;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.notePayable.util.AbstractNoteImpl;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import kd.ebg.note.common.framework.utils.ParserUtils;
import org.jdom2.Element;

public class NoteDetailUtil
extends AbstractNoteImpl {
    public void queryNoteDetails(Detail detailInfo, BankAcnt acnt) {
        String str = this.packNoteDetail(detailInfo, acnt);
        String rep = this.doBussiness(str);
        this.parseNoteDetail(detailInfo, rep);
    }

    private String packNoteDetail(Detail detailInfo, BankAcnt acnt) {
        if (StringUtils.isEmpty((String)detailInfo.getNoteNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f3a\u5c11\u7968\u636e\u53f7\u67e5\u8be2\u67e5\u8be2\u6761\u4ef6", (String)"NoteDetailUtil_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD38");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1035", "");
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)detailInfo.getNoteNo());
        JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange(detailInfo.getStartNo()));
        JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange(detailInfo.getEndNo()));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    private void parseNoteDetail(Detail detailInfo, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        String RespInfo = root.getChildTextTrim("RespInfo");
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (ResManager.loadKDString((String)"\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55", (String)"NoteDetailUtil_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo) || ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e", (String)"NoteDetailUtil_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo)) {
            return;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%s", (String)"NoteDetailUtil_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return;
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        if ("1".equals(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getDetailRspRecordsNew(fileName, "");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|_|");
        }
        int fieldNum = Integer.parseInt(fieldNumStr);
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>(1);
        for (int i = recordNum - 1; i >= 0; --i) {
            String bizType = splits[fieldNum * i];
            String sqrqddm = splits[fieldNum * i + 1];
            String accountNo = splits[fieldNum * i + 2];
            String accountName = splits[fieldNum * i + 3];
            String sqrxydm = splits[fieldNum * i + 4];
            String accountBankCnaps = splits[fieldNum * i + 5];
            String accountBankName = splits[fieldNum * i + 6];
            String ydrqddm = splits[fieldNum * i + 7];
            String signerNo = splits[fieldNum * i + 9];
            String signerName = splits[fieldNum * i + 10];
            String singersCnaps = splits[fieldNum * i + 12];
            String singersBankName = splits[fieldNum * i + 13];
            String endorTpDic = splits[fieldNum * i + 14];
            String rate = splits[fieldNum * i + 15];
            String sgnUpMkDic = splits[fieldNum * i + 16];
            String sqrremark = splits[fieldNum * i + 17];
            String ydrremark = splits[fieldNum * i + 18];
            String stlRstDic = splits[fieldNum * i + 19];
            String transFlag = splits[fieldNum * i + 20];
            String bsnum = splits[fieldNum * i + 21];
            if (!"ET03".equals(endorTpDic) && !"ET04".equals(endorTpDic) && !"ET05".equals(endorTpDic) && !"ET14".equals(endorTpDic)) continue;
            NoteSidesInfo sidesDetail = new NoteSidesInfo();
            sidesDetail.setAccountNo(accountNo);
            sidesDetail.setAcountBankCnaps(accountBankCnaps);
            sidesDetail.setOpponentName(signerName);
            sidesDetail.setOpponentAcNo(signerNo);
            sidesDetail.setResv1(result.size() + "");
            sidesDetail.setSignDate(rate.replaceAll("-", ""));
            sidesDetail.setInitiatorAcNo(accountNo);
            sidesDetail.setInitiatorName(accountName);
            sidesDetail.setBusinessCode(this.getBusinessCode(endorTpDic));
            result.add(sidesDetail);
        }
        detailInfo.setNoteSidesInfo(result);
    }

    public String getBusinessCode(String bankCode) {
        HashMap<String, String> bankHandleCodeToEbgCode = new HashMap<String, String>(){
            {
                this.put("ET03", "18");
                this.put("ET04", "19");
                this.put("ET05", "10");
                this.put("ET14", "11");
            }
        };
        return (String)bankHandleCodeToEbgCode.get(bankCode);
    }
}

