/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.payable;

import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.AbstractNoteImpl;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryStatusNoteImpl
extends AbstractNoteImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryStatusNoteImpl.class);

    public void getStatus(BankNotePayableRequest bankNotePayableRequest, String DistTp) {
        String str = this.packNoteStatusPay(bankNotePayableRequest, DistTp);
        String rep = this.doBussiness(str);
        this.parseNoteStatus(bankNotePayableRequest.getNotePayableInfosAsArray(), rep);
    }

    public String packNoteStatusPay(BankNotePayableRequest bankNotePayableRequest, String DistTp) {
        BankAcnt acnt = bankNotePayableRequest.getAcnt();
        NotePayableInfo[] infos = bankNotePayableRequest.getNotePayableInfosAsArray();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD37");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)infos[0].getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1034", "");
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)DistTp);
        JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)infos[0].getBillNo());
        JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)infos[0].getStartNo());
        JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)infos[0].getEndNo());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public void parseNoteStatus(NotePayableInfo[] infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        this.logger.info("respCode:" + rspCode);
        if (!"0000".equals(rspCode)) {
            this.logger.info("\u67e5\u8be2\u660e\u7ec6\u51fa\u9519\uff1a" + infos[0].getBillNo());
            return;
        }
        Element Hermes = root.getChild("Hermes");
        Element BillInf = Hermes.getChild("BillInf");
        String CdNo = BillInf.getChildTextTrim("CdNo");
        String CdRangeStart = BillInf.getChildTextTrim("CdRangeStart");
        String CdRangeEnd = BillInf.getChildTextTrim("CdRangeEnd");
        String CdStatus = BillInf.getChildTextTrim("CdStatus");
        String CdTransStatus = BillInf.getChildTextTrim("CdTransStatus");
        String RiskStatus = BillInf.getChildTextTrim("RiskStatus");
        infos[0].setBillNo(CdNo);
        infos[0].setNoteStatus(CdStatus);
        if (!StringUtils.isEmpty((String)CdRangeStart)) {
            infos[0].setStartNo(CdRangeStart);
        }
        if (!StringUtils.isEmpty((String)CdRangeEnd)) {
            infos[0].setEndNo(CdRangeEnd);
        }
        infos[0].setKeepFlag(CdTransStatus);
        infos[0].setCirStatus(CdTransStatus);
        infos[0].setReserved3(RiskStatus);
        this.logger.info("\u7968\u636e\u72b6\u6001\u540c\u6b65\uff0c\u7968\u636e\u5305\u53f7\uff1a" + CdNo + ",\u5b50\u7968\u533a\u95f4\uff1a" + CdRangeStart + "," + CdRangeEnd + ",\u7968\u636e\u72b6\u6001\uff1a" + CdStatus + ",\u6d41\u901a\u6807\u8bc6\uff1a" + CdTransStatus);
    }
}

