/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.payable.revocation;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.payable.QueryPayableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RevocationNoteImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryPayableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRC52";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500\u51fa\u7968", (String)"RevocationNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        NotePayableInfo info = (NotePayableInfo)bankNotePayableRequest.getNotePayableInfoList().get(0);
        BankAcnt acnt = bankNotePayableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CFRC52");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1014", "");
        JDomUtils.addChild((Element)hermes, (String)"BusiNo", (String)Sequence.gen14Sequence());
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info.getExplanation());
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)CustInf, (String)"ConAcctSvcr", (String)acnt.getCnaps());
        Element BillInf = JDomUtils.addChild((Element)hermes, (String)"BillInf");
        JDomUtils.addChild((Element)BillInf, (String)"CdNo", (String)info.getBillNo());
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange(info.getStartNo()));
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange(info.getEndNo()));
        JDomUtils.addChild((Element)BillInf, (String)"CdAmt", (String)info.getAmount().setScale(2).toString());
        Element BusiInf = JDomUtils.addChild((Element)hermes, (String)"BusiInf");
        JDomUtils.addChild((Element)BusiInf, (String)"AppDt", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)BusiInf, (String)"Note", (String)info.getExplanation());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        return NewNoteParser.parse(bankNotePayableRequest, rspStr);
    }
}

