/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.QueryReceivableStatusNoteImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryReceivableNoteImpl
extends AbstractQueryNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReceivableNoteImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRD39";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u67e5\u8be2\u5e94\u6536\u7968\u636e", (String)"QueryReceivableNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        List notePayableinfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD39");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1036", "");
        JDomUtils.addChild((Element)hermes, (String)"BusiNo", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved1());
        if (StringUtils.isEmpty((String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved2())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\uff0c\u8bf7\u4eba\u5de5\u786e\u8ba4\u3002", (String)"QueryReceivableNoteImpl_8", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), new Object[0]));
        }
        JDomUtils.addChild((Element)hermes, (String)"BusiType", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved2());
        String busiType = ((NoteReceivableInfo)notePayableinfos.get(0)).getReserved2();
        if (!StringUtils.isEmpty((String)((NoteReceivableInfo)notePayableinfos.get(0)).getBillNo()) && ("TAKA01".equals(busiType) || "TRKA01".equals(busiType))) {
            JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getBillNo());
            JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getStartNo());
            JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getEndNo());
        }
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        String direction = "ST00";
        if ("note_signin".equals(bankNoteReceivableRequest.getHeader().getSubBizType())) {
            direction = "ST01";
        }
        JDomUtils.addChild((Element)hermes, (String)"Direction", (String)direction);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rspStr) {
        List infos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        this.logger.info("respCode:" + rspCode);
        if (!"0000".equals(rspCode)) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return infos;
        }
        Element Hermes = root.getChild("Hermes");
        String CdNo = Hermes.getChildTextTrim("CdNo");
        String CdRangeStart = Hermes.getChildTextTrim("CdRangeStart");
        String CdRangeEnd = Hermes.getChildTextTrim("CdRangeEnd");
        String DealDtTm = Hermes.getChildTextTrim("DealDtTm");
        String DealResult = Hermes.getChildTextTrim("DealResult");
        String BusiStatus = Hermes.getChildTextTrim("BusiStatus");
        String SgnUpMk = Hermes.getChildTextTrim("SgnUpMk");
        String AppvStatus = Hermes.getChildTextTrim("AppvStatus");
        if (!StringUtils.isEmpty((String)CdNo)) {
            ((NoteReceivableInfo)infos.get(0)).setBillNo(CdNo);
        }
        if (!StringUtils.isEmpty((String)CdRangeStart)) {
            ((NoteReceivableInfo)infos.get(0)).setStartNo(CdRangeStart);
        }
        if (!StringUtils.isEmpty((String)CdRangeEnd)) {
            ((NoteReceivableInfo)infos.get(0)).setEndNo(CdRangeEnd);
        }
        String BusiNo = ((NoteReceivableInfo)infos.get(0)).getReserved1();
        String reqCode = "DT02";
        String BusiType = ((NoteReceivableInfo)infos.get(0)).getReserved2();
        if ("SPBS05".equals(BusiStatus) || "SPBS14".equals(BusiStatus) || "SPBS15".equals(BusiStatus)) {
            if ("note_signin".equals(((NoteReceivableInfo)infos.get(0)).getSubBizType()) && "SU01".equals(((NoteReceivableInfo)infos.get(0)).getOtherInfo())) {
                ((NoteReceivableInfo)infos.get(0)).setNoteStatus("CS03");
                ((NoteReceivableInfo)infos.get(0)).setCirStatus("TF0301");
            } else {
                new QueryReceivableStatusNoteImpl().getStatus(bankNoteReceivableRequest, reqCode);
            }
            if ("TAED01".equals(BusiType) || "TAPG01".equals(BusiType) || "TAPR01".equals(BusiType) || "TADC01".equals(BusiType) || "TAPP01".equals(BusiType)) {
                if ("SPBS14".equals(BusiStatus)) {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)DealResult);
                } else if ("SPBS15".equals(BusiStatus)) {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)BusiStatus, (String)DealResult);
                } else {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                }
            } else if ("TRPP01".equals(BusiType)) {
                if ("SPBS14".equals(BusiStatus)) {
                    String cirStatus = ((NoteReceivableInfo)infos.get(0)).getCirStatus();
                    if ("CS06".equals(((NoteReceivableInfo)infos.get(0)).getNoteStatus()) && "TF0501".equals(cirStatus)) {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                    } else {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                    }
                } else if ("SPBS15".equals(BusiStatus)) {
                    String cirStatus = ((NoteReceivableInfo)infos.get(0)).getCirStatus();
                    if ("CS03".equals(((NoteReceivableInfo)infos.get(0)).getNoteStatus()) && ("TF0301".equals(cirStatus) || "TF0303".equals(cirStatus))) {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                    } else {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                    }
                } else {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                }
            } else if ("TRAT01".equals(BusiType) || "TRRB01".equals(BusiType) || "TRED01".equals(BusiType) || "TRGT01".equals(BusiType) || "TRPG01".equals(BusiType) || "TRPR01".equals(BusiType)) {
                if ("SPBS14".equals(BusiStatus) || "SPBS15".equals(BusiStatus)) {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                } else {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                }
            } else if ("SPBS05".equals(BusiStatus)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
            }
        } else if ("SPBS00".equals(BusiStatus) || "SPBS03".equals(BusiStatus) || "SPBS07".equals(BusiStatus) || "SPBS10".equals(BusiStatus) || "SPBS30".equals(BusiStatus) || "SPBS31".equals(BusiStatus)) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
        } else if ("SPBS04".equals(BusiStatus) || "SPBS06".equals(BusiStatus) || "SPBS11".equals(BusiStatus) || "SPBS13".equals(BusiStatus) || "SPBS16".equals(BusiStatus) || "SPBS17".equals(BusiStatus) || "SPBS18".equals(BusiStatus) || "SPBS19".equals(BusiStatus) || "SPBS32".equals(BusiStatus)) {
            new QueryReceivableStatusNoteImpl().getStatus(bankNoteReceivableRequest, reqCode);
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)BusiStatus, (String)DealResult);
        } else if ("SPBS15".equals(BusiStatus)) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)BusiStatus, (String)DealResult);
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

